class CreateArcThumbs < ActiveRecord::Migration
  def self.up
    create_table :arc_thumbs do |t|
      t.references :arc
      t.string :thumb_id, :limit => 15

      t.timestamps
    end
    add_index :arc_thumbs, [ :arc_id, :thumb_id ], :unique => true
  end

  def self.down
    remove_index :arc_thumbs, :column => [ :arc_id, :thumb_id ]
    drop_table :arc_thumbs
  end
end
