class CreateThumbs < ActiveRecord::Migration
  def self.up
    create_table :thumbs, :id => false do |t|
      t.string :video_id, :limit => 15, :null => false
      t.string :title
      t.text :description

      t.timestamps
    end
    add_index :thumbs, [ :video_id ], :unique => true
  end

  def self.down
    remove_index :thumbs, :column => [ :video_id ]
    drop_table :thumbs
  end
end
