#!ruby
# vim: fileencoding=utf-8

location_code = ARGV.shift || 'mmd'
location = Location.find_by_code(location_code)
unless location
  puts "location not found."
  exit
end

while line = gets
  case line
  when /^$/
    #
  when /^error:/
    #
  when /^# (.+)/
    path = $1
    basename = File.basename(path)
    md = /\.(.+)\z/.match(basename)
    extname = md[1]
    code = basename.sub(/\.(.+)\z/, '')
    case location.code
    when 'mmd'
      #
    when 'mmdfile'
      code = 'file%04d' % code.to_i
    when 'mmdacc1'
      code = 'mini%04d' % code.to_i
    when 'mmdacc2'
      code = code[3..-1]
    end
    arc = Arc.find_by_location_id_and_code(location.id, code)
  else
    size, comp_size, date, path = line.chomp.split(/\t/)
    if arc && /\.pmd\z/.match(path)
      puts [ code, path ].join(' ')
      Pmd.create(:arc => arc, :path => path)
    end
    if arc && /\.vmd\z/.match(path)
      puts [ code, path ].join(' ')
      Vmd.create(:arc => arc, :path => path)
    end
    if arc && /\.x\z/.match(path)
      puts [ code, path ].join(' ')
      X.create(:arc => arc, :path => path)
    end
  end
end
