#!ruby
# vim: fileencoding=utf-8

location_code = ARGV.shift || 'mmd'
location = Location.find_by_code(location_code)
unless location
  puts "location not found."
  exit
end

while line = gets
  case location.code
  when 'mmd'
    name, summary, size, date, mime, origname, with_key, with_password = line.chomp.split(/\t/)
  when 'mmdfile', 'mmdacc1', 'mmdacc2'
    name, summary, size, date, origname = line.chomp.split(/\t/)
  end
  md = /\.(.+)\z/.match(name)
  extname = md[1]
  code = File.basename(name, '.' + extname)
  case location.code
  when 'mmd'
    #
  when 'mmdfile'
    code = 'file%04d' % code.to_i
  when 'mmdacc1'
    code = 'mini%04d' % code.to_i
  when 'mmdacc2'
    code = code[3..-1]
  end
  puts [ code, extname ].join(' ')
  Arc.create(:code => code, :extname => extname, :location => location, :summary => summary, :origname => origname)
end
