class Pmd < ActiveGroonga::Base
  def self.search(search)
    if search.path.blank?
      all
    else
      select { |rec|
        rec.match(search.path) { |mat|
          (mat.path * 1)
        }
      }
    end
  end

  class Search
    attr_accessor :path

    def initialize(attributes)
      attributes.each do |name, value|
        send("#{name}=", value)
      end if attributes
      self.path ||= ''
    end

    def text=(text)
      self.path = text
    end
  end
end
