class Arc < ActiveGroonga::Base
  def self.search(search)
    if search.text.blank?
      all
    else
      select { |rec|
        rec.match(search.text) { |mat|
          (mat.summary * 1) | (mat.origname * 1)
        }
      }
    end
  end

  def code
    key
  end
  def pmds
    Pmd.select { |pmd| pmd.arc == key }
  end
  def vmds
    Vmd.select { |vmd| vmd.arc == key }
  end
  def xes
    X.select { |x| x.arc == key }
  end

  def site_code
    /([a-z]+)/.match(code).to_a[1]
  end

  def number
    /([0-9]+)/.match(code).to_a[1].to_i
  end

  def path_for_mmd
    if locked
      "upload.cgi?mode=dl&file=#{number}"
    else
      "src/#{code}.#{extname}"
    end
  end
  def path_for_mmdfile
    if locked
      "?mode=pass&idd=#{number}"
    else
      "?id=#{number}"
    end
  end
  def path_for_mmdacc1
    "log/#{number}.#{extname}"
  end
  def path_for_mmdacc2
    "src/MMD#{code}.#{extname}.html"
  end
  def path_for_mmd3dcu
    if locked
      "upload.cgi?mode=dl&file=#{number}"
    else
      fixed_number = '%05d' % number
      "src/MMD#{fixed_number}.#{extname}"
    end
  end
  def path_for_mmdbowl
    "dl#{number}"
  end
  def path_for_site
    send("path_for_#{site.key}")
  end

  def url
    site.url + path_for_site
  end

  class Search
    attr_accessor :text

    def initialize(attributes)
      attributes.each do |name, value|
        send("#{name}=", value)
      end if attributes
    end
  end
end
