class XesController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /xes
  # GET /xes.xml
  def index
    @search = X::Search.new(params[:search])
    @xes = X.search(@search).paginate([ '_id' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @xes }
    end
  end
end
