class WelcomeController < ApplicationController
  layout 'arcs'

  def index
    @search = Welcome::Search.new(params[:search])
    if @search.text.blank?
      time = Time.now - 3 * 24 * 60 * 60
      @arcs = Arc.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 30)
      @pmds = Pmd.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 15)
      @vmds = Vmd.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 15)
      @xes = X.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 15)
      @thumbs = Thumb.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 15)
      @seigas = Seiga.select { |rec| rec.updated_at > time }.paginate([ :key => 'updated_at', :order => :desc ], :size => 15)
    else
      @arc_search = Arc::Search.new(params[:search])
      @arcs = Arc.search(@arc_search).paginate([ 'site', '_key' ], :size => 15, :page => params[:page])
      @pmd_search = Pmd::Search.new(params[:search])
      @pmds = Pmd.search(@pmd_search).paginate([ '_id' ], :size => 15, :page => params[:page])
      @vmd_search = Vmd::Search.new(params[:search])
      @vmds = Vmd.search(@vmd_search).paginate([ '_id' ], :size => 15, :page => params[:page])
      @x_search = X::Search.new(params[:search])
      @xes = X.search(@x_search).paginate([ '_id' ], :size => 15, :page => params[:page])
      @thumb_search = Thumb::Search.new(params[:search])
      @thumbs = Thumb.search(@thumb_search).paginate([ '_id' ], :size => 15, :page => params[:page])
      @seiga_search = Seiga::Search.new(params[:search])
      @seigas = Seiga.search(@seiga_search).paginate([ '_id' ], :size => 15, :page => params[:page])
    end
  end

end
