class ThumbsController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /thumbs
  # GET /thumbs.xml
  def index
    @search = Thumb::Search.new(params[:search])
    @thumbs = Thumb.search(@search).paginate([ '_id' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @thumbs }
    end
  end

  # GET /thumbs/1
  # GET /thumbs/1.xml
  def show
    @thumb = Thumb.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @thumb }
    end
  end
end
