class SeigasController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /seigas
  # GET /seigas.xml
  def index
    @search = Seiga::Search.new(params[:search])
    @seigas = Seiga.search(@search).paginate([ '_id' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @seigas }
    end
  end

  # GET /seigas/1
  # GET /seigas/1.xml
  def show
    @seiga = Seiga.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @seiga }
    end
  end
end
