class ArcsController < ApplicationController
  layout 'arcs'
  before_filter :login_required, :only => [ :new, :edit, :create, :update, :destroy ]

  # GET /arcs
  # GET /arcs.xml
  def index
    @search = Arc::Search.new(params[:search])
    @arcs = Arc.search(@search).paginate([ 'site', '_key' ], :size => 30, :page => params[:page])

    respond_to do |format|
      format.html # index.html.erb
      format.xml  { render :xml => @arcs }
    end
  end

  # GET /arcs/1
  # GET /arcs/1.xml
  def show
    @arc = Arc.find(params[:id])

    respond_to do |format|
      format.html # show.html.erb
      format.xml  { render :xml => @arc }
    end
  end
end
