﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace SST.設定
{
	class Config
	{
		public bool 垂直帰線待ちを行う { get; set; }

		public SharpDX.Size2 物理画面サイズpx { get; set; }

		public int 動画デコーダのキューサイズ { get; set; }

		public Config()
		{
			this._初期化する();
		}

		public void ConfigXmlを保存する()
		{
			this.ConfigXmlを保存する( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this._ConfigXmlファイルパス ) );
		}

		public void ConfigXmlを保存する( string ファイルパス )
		{
			try
			{
				var XML文書 = new XDocument( new XDeclaration( version: "1.0", encoding: "utf-8", standalone: "yes" ),

					new XElement( nameof( XML.Root ),

						new XElement( nameof( XML.Config ),

							new XComment( "垂直帰線待ちを行う場合はtrue、行わない場合はfalseを設定します。" ),
							new XElement( nameof( XML.WaitForVerticalBlank ), this.垂直帰線待ちを行う ),

							new XComment( "画面に関する設定を行います。" ),
							new XElement( nameof( XML.Screen ),

								new XComment( "画面の幅を設定します。" ),
								new XElement( nameof( XML.Width ), this.物理画面サイズpx.Width ),

								new XComment( "画面の高さを設定します。" ),
								new XElement( nameof( XML.Height ), this.物理画面サイズpx.Height )
							),

							new XComment( "動画に関する設定を行います。" ),
							new XElement( nameof( XML.Movie ),

								new XComment( "動画デコーダのキューサイズを設定します。" ),
								new XElement( nameof( XML.QueueSize ), this.動画デコーダのキューサイズ )
							)
						)
					)
				);

				XML文書.Save( ファイルパス );
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"コンフィグファイルの保存に失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}
		}

		public void ConfigXmlを読み込む()
		{
			this.ConfigXmlを読み込む( FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this._ConfigXmlファイルパス ) );
		}

		public void ConfigXmlを読み込む( string ファイルパス )
		{
			this._初期化する();

			if( false == File.Exists( ファイルパス ) )
			{
				FDK.Log.WARNING( $"コンフィグファイルが存在しません。作成します。[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
				this.ConfigXmlを保存する( ファイルパス );
				return;
			}

			try
			{
				var XML文書 = XDocument.Load( ファイルパス );

				// <Root>
				var Root要素 = XML文書.Element( nameof( XML.Root ) );
				{
					// <Config>*
					foreach( var Config要素 in Root要素.Elements( nameof( XML.Config ) ) )
					{
						#region " <WaitForVerticalBlank> "
						//----------------
						try
						{
							this.垂直帰線待ちを行う = (bool) Config要素.Element( nameof( XML.WaitForVerticalBlank ) );
						}
						catch( Exception e )
						{
							FDK.Log.ERROR( $"<{XML.Config}>.<{XML.WaitForVerticalBlank}> の読み込みに失敗しました。{e.Message}" );
						}
						//----------------
						#endregion

						// <Screen>*
						foreach( var Screen要素 in Config要素.Elements( nameof( XML.Screen ) ) )
						{
							#region " <Width> "
							//----------------
							try
							{
								int width = (int) Screen要素.Element( nameof( XML.Width ) );
								this.物理画面サイズpx = new SharpDX.Size2( width, this.物理画面サイズpx.Height );
							}
							catch( Exception e )
							{
								FDK.Log.ERROR( $"<{XML.Config}>.<{XML.Screen}>.<{XML.Width}> の読み込みに失敗しました。{e.Message}" );
							}
							//----------------
							#endregion
							#region " <Height> "
							//----------------
							try
							{
								int height = (int) Screen要素.Element( nameof( XML.Height ) );
								this.物理画面サイズpx = new SharpDX.Size2( this.物理画面サイズpx.Width, height );
							}
							catch( Exception e )
							{
								FDK.Log.ERROR( $"<{XML.Config}>.<{XML.Screen}>.<{XML.Height}> の読み込みに失敗しました。{e.Message}" );
							}
							//----------------
							#endregion
						}

						// <Movie>*
						foreach( var Movie要素 in Config要素.Elements( nameof( XML.Movie ) ) )
						{
							#region " <QueueSize> "
							//----------------
							try
							{
								this.動画デコーダのキューサイズ = (int) Movie要素.Element( nameof( XML.QueueSize ) );
							}
							catch( Exception e )
							{
								FDK.Log.ERROR( $"<{XML.Config}>.<{XML.Movie}>.<{XML.QueueSize}> の読み込みに失敗しました。{e.Message}" );
							}
							//----------------
							#endregion
						}
					}
				}
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ユーザファイルの読み込みに失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}
		}

		private readonly string _ConfigXmlファイルパス = @"$(AppData)\Config.xml";

		private void _初期化する()
		{
			// 各メンバの規定値を設定する。

			this.垂直帰線待ちを行う = true;
			this.物理画面サイズpx = new SharpDX.Size2( 1280, 720 );
			this.動画デコーダのキューサイズ = 16;
		}
	}
}
