﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Xml.Linq;

namespace SST.ユーザ
{
	public class ユーザ管理
	{
		public List<ユーザ> ユーザリスト { get; protected set; } = new List<ユーザ>();

		public ユーザ 現在選択されているユーザ { get; protected set; } = null;	// 外から設定するにはメソッドを使う。

		public ユーザ管理()
		{
			this._初期化する();
		}

		public void ユーザを選択する( string ユーザ名 )
		{
			var 名前に該当するユーザ = this.ユーザリスト.Find( ( user ) => ( user.名前 == ユーザ名 ) );
			if( null == 名前に該当するユーザ )
			{
				var msg = $"存在しない名前「{ユーザ名}」のユーザを選択しようとしました。";
				FDK.Log.ERROR( msg );
				throw new SSTException( msg );
			}

			// 選択ユーザを変更する。
			this.現在選択されているユーザ = 名前に該当するユーザ;
		}

		public void 最初のユーザを選択する()
		{
			this.現在選択されているユーザ = ( 0 < this.ユーザリスト.Count ) ? this.ユーザリスト[ this.ユーザリスト.Count - 1 ] : null;
		}

		public void 前のユーザを選択する()
		{
			if( ( null == this.現在選択されているユーザ ) || ( 0 == this.ユーザリスト.Count ) )
			{
				this.現在選択されているユーザ = ( 0 < this.ユーザリスト.Count ) ? this.ユーザリスト[ this.ユーザリスト.Count - 1 ] : null;
			}
			else
			{
				int index = this.ユーザリスト.FindIndex( ( user ) => ( user == this.現在選択されているユーザ ) );

				if( -1 == index )
					throw new SSTException( "ユーザリストに存在しないユーザが選択されています。" );

				if( --index < 0 )
					index = this.ユーザリスト.Count - 1;

				this.現在選択されているユーザ = this.ユーザリスト[ index ];
			}
		}

		public void 次のユーザを選択する()
		{
			if( ( null == this.現在選択されているユーザ ) || ( 0 == this.ユーザリスト.Count ) )
			{
				this.現在選択されているユーザ = ( 0 < this.ユーザリスト.Count ) ? this.ユーザリスト[ 0 ] : null;
			}
			else
			{
				int index = this.ユーザリスト.FindIndex( ( user ) => ( user == this.現在選択されているユーザ ) );

				if( -1 == index )
					throw new SSTException( "ユーザリストに存在しないユーザが選択されています。" );

				if( ++index >= this.ユーザリスト.Count )
					index = 0;

				this.現在選択されているユーザ = this.ユーザリスト[ index ];
			}
		}

		public void UsersXmlを保存する()
		{
			string ファイルパス = FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this._UsersXmlファイルパス );

			try
			{
				var XML文書 = new XDocument( new XDeclaration( version: "1.0", encoding: "utf-8", standalone: "yes" ) );

				// <Root>
				var Root要素 = new XElement( nameof( XML.Root ) );
				{
					// <Users>
					var Users要素 = new XElement( nameof( XML.Users ) );
					{
						// ユーザ要素*
						foreach( var user in this.ユーザリスト )
						{
							user.ユーザをXML要素で出力する( 親要素: Users要素 );
						}
					}
					Root要素.Add( Users要素 );
				}
				XML文書.Add( Root要素 );

				// ファイルに保存する。
				XML文書.Save( ファイルパス );
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ユーザファイルの保存に失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}
		}

		public void UsersXmlを読み込む()
		{
			string ファイルパス = FDK.フォルダ.絶対パスに含まれるフォルダ変数を展開して返す( this._UsersXmlファイルパス );

			this._初期化する();

			if( false == File.Exists( ファイルパス ) )
			{
				FDK.Log.WARNING( $"ユーザファイルが存在しません。作成します。[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
				this._AutoPlayerを追加する();
				this.UsersXmlを保存する();
				return;
			}

			try
			{
				var XML文書 = XDocument.Load( ファイルパス );

				// <Root>
				var Root要素 = XML文書.Element( nameof( XML.Root ) );
				{
					// <Users>*
					foreach( var Users要素 in Root要素.Elements( nameof( XML.Users ) ) )
					{
						// ユーザ要素*
						foreach( var ユーザ要素 in Users要素.Elements() )
						{
							var 新ユーザ = new ユーザ();
							新ユーザ.ユーザをXML要素から読み込む( 読込対象要素: ユーザ要素 );  // ユーザ要素の解析は向こうに任せる。

							if( false == string.IsNullOrEmpty( 新ユーザ.名前 ) )
							{
								// すでに同じ名前が存在するなら削除する。
								var 同名ユーザ = this.ユーザリスト.FindIndex( ( user ) => ( user.名前 == 新ユーザ.名前 ) );
								if( 0 <= 同名ユーザ )
									this.ユーザリスト.RemoveAt( 同名ユーザ );

								// リストに追加する。
								this.ユーザリスト.Add( 新ユーザ );
							}
						}
					}
				}
			}
			catch( Exception e )
			{
				FDK.Log.ERROR( $"ユーザファイルの読み込みに失敗しました。{e.Message}[{FDK.フォルダ.絶対パスをフォルダ変数付き絶対パスに変換して返す( ファイルパス )}]" );
			}

			// AutoPlayer が存在しないなら、追加する。
			if( -1 == this.ユーザリスト.FindIndex( ( user ) => user.名前 == Properties.Resources.AUTOPLAYER ) )
			{
				this._AutoPlayerを追加する();
			}
		}

		private readonly string _UsersXmlファイルパス = @"$(AppData)\Users.xml";

		private void _初期化する()
		{
			this.ユーザリスト.Clear();
			this.現在選択されているユーザ = null;
		}

		private void _AutoPlayerを追加する()
		{
			var autoPlayer = new ユーザ( Properties.Resources.AUTOPLAYER );
			autoPlayer.チップの自動演奏を一括設定する( true );
			autoPlayer.曲の検索元フォルダパスのリスト.Add( @"$(Static)\songs" );
			autoPlayer.SourcesXmlを保存する();
			this.ユーザリスト.Add( autoPlayer );
			this.UsersXmlを保存する();

			FDK.Log.Info( "ユーザリストに AutoPlayer を追加しました。" );
		}
	}
}
