﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.演奏
{
	class ヒット判定文字列 : FDK.Activity
	{
		public ヒット判定文字列()
		{
			// すべての文字列画像を子リストに追加。
			foreach( var kvp in this._文字列画像 )
				this.子リスト.Add( kvp.Value );
		}

		public void 表示開始( ヒットレーン種別 レーン種別, ヒット判定種別 ヒット判定種別 )
		{
			lock( this._スレッド間同期 )
			{
				if( レーン種別 == ヒットレーン種別.Unknown )
					return;

				// レーンに対応する進行描画コンテキストを更新し、表示を開始するためのパラメータを設定する。
				if( this._ヒット判定レーンto進行描画コンテキスト.ContainsKey( レーン種別 ) ) // すでにあったら、
					this._ヒット判定レーンto進行描画コンテキスト.Remove( レーン種別 );       // 削除してから、
				this._ヒット判定レーンto進行描画コンテキスト.Add(                           // 追加。
					レーン種別,
					new 進行描画コンテキスト() {
						ヒット判定種別 = ヒット判定種別,
						進行カウンタ = new FDK.カウンタ.単純増加後不変カウンタ( 最初の値: 0, 最後の値: 300, 値をひとつ増加させるのにかける時間ms: 1 ),    // カウント開始（＝表示開始）
						X方向拡大率 = 1f,
						Y方向拡大率 = 1f,
						相対X座標dpx = 0,
						相対Y座標dpx = 0,
						透明度0to1 = 1f,
					} );
			}
		}

		public void 表示開始( SSTFormat.チップ種別 チップ種別, ヒット判定種別 ヒット判定種別 )
		{
			lock( this._スレッド間同期 )
			{
				var レーン種別 = チップ種別.対応するヒットレーン種別を返す();
				this.表示開始( レーン種別, ヒット判定種別 );
			}
		}

		protected override void On活性化( デバイスリソース dr )
		{
			// すべてのヒット判定レーンに対する進行描画コンテキストを生成する。
			this._ヒット判定レーンto進行描画コンテキスト = new Dictionary<ヒットレーン種別, 進行描画コンテキスト>();
			foreach( var judgeType in typeof( ヒットレーン種別 ).GetEnumValues() )
				this._ヒット判定レーンto進行描画コンテキスト.Add( (ヒットレーン種別) judgeType, new 進行描画コンテキスト() );
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			this._ヒット判定レーンto進行描画コンテキスト.Clear();
		}

		public void 進行描画する( デバイスリソース dr )
		{
			lock( this._スレッド間同期 )
			{
				// すべての ヒットレーン種別 について、進行描画する。
				foreach( var lane_object in typeof( ヒットレーン種別 ).GetEnumValues() )
				{
					var lane = (ヒットレーン種別) lane_object;
					var context = this._ヒット判定レーンto進行描画コンテキスト[ lane ];

					if( context.進行カウンタ.停止中である )
						continue;   // カウンタが停止中 → このレーンについては何もしない。

					// 進行。

					#region " 進行カウンタが終了値に達したら停止 → 表示完了。"
					//----------------
					if( context.進行カウンタ.終了値に達した )
					{
						context.進行カウンタ.一時停止する();
						continue;
					}
					//----------------
					#endregion

					if( context.ヒット判定種別 != ヒット判定種別.MISS )
					{
						#region " (A) Perfect, Great, Good, Poor, Auto のアニメーション進行。"
						//-----------------
						if( context.進行カウンタ.現在値 < 50 )
						{
							// (B-a) 0～49
							context.X方向拡大率 = 1.0f + ( 1.0f * ( 1.0f - ( context.進行カウンタ.現在値 / 50.0f ) ) );
							context.Y方向拡大率 = context.進行カウンタ.現在値 / 50.0f;
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						else if( context.進行カウンタ.現在値 < 130 )
						{
							// (B-b) 50～129
							context.X方向拡大率 = 1.0f;
							context.Y方向拡大率 = 1.0f;
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = ( ( context.進行カウンタ.現在値 % 6 ) == 0 ) ? ( StrokeStyleT.乱数.Next( 6 ) - 3 ) : context.相対Y座標dpx;
							context.透明度0to1 = 1.0f;
						}
						else if( context.進行カウンタ.現在値 < 240 )
						{
							// (B-c) 130～239
							context.X方向拡大率 = 1.0f;
							context.Y方向拡大率 = 1.0f;
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						else
						{
							// (B-d) 240～300
							context.X方向拡大率 = 1.0f;
							context.Y方向拡大率 = 1.0f - ( ( 1.0f * ( context.進行カウンタ.現在値 - 240 ) ) / 60.0f );
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						//-----------------
						#endregion
					}
					else
					{
						#region " (B) Miss のアニメーション進行だけ他とは違ってたり。"
						//-----------------
						if( context.進行カウンタ.現在値 < 50 )
						{
							// (A-a) 0～49
							context.X方向拡大率 = 1.0f;
							context.Y方向拡大率 = context.進行カウンタ.現在値 / 50.0f;
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						else if( context.進行カウンタ.現在値 < 200 )
						{
							// (A-b) 50～199
							context.X方向拡大率 = 1.0f;
							context.Y方向拡大率 = 1.0f;
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						else
						{
							// (A-c) 200～300
							context.X方向拡大率 = 1.0f - ( ( context.進行カウンタ.現在値 - 200 ) / 100.0f );
							context.Y方向拡大率 = 1.0f - ( ( context.進行カウンタ.現在値 - 200 ) / 100.0f );
							context.相対X座標dpx = 0;
							context.相対Y座標dpx = 0;
							context.透明度0to1 = 1.0f;
						}
						//-----------------
						#endregion
					}

					// 描画。

					var 判定文字列の画像 = this._文字列画像[ context.ヒット判定種別 ];
					if( 判定文字列の画像.生成失敗 )
						return;

					var 判定文字列の左上端位置 =
						new SharpDX.Vector2( context.相対X座標dpx, context.相対Y座標dpx )
						+ new SharpDX.Vector2( lane.レーンの中央X位置dpx(), lane.ヒット文字列の中央Y位置dpx() )
						+ new SharpDX.Vector2(
							-( ( 判定文字列の画像.サイズdpx.Width * context.X方向拡大率 ) / 2f ),
							-( ( 判定文字列の画像.サイズdpx.Height * context.Y方向拡大率 ) / 2f ) );

					判定文字列の画像?.描画する(
						dr,
						左位置dpx: 判定文字列の左上端位置.X,
						上位置dpx: 判定文字列の左上端位置.Y,
						不透明度0to1: context.透明度0to1,
						X方向拡大率: context.X方向拡大率,
						Y方向拡大率: context.Y方向拡大率 );
				}
			}
		}

		/// <summary>
		///		ヒット判定レーンには、それぞれに１つずつの進行描画コンテキストを用意する。
		/// </summary>
		private class 進行描画コンテキスト
		{
			/// <summary>
			/// ヒット判定文字列のアニメ進行用カウンタ。
			/// このカウンタが動作中のときのみ、ヒット判定文字列が描画される。
			/// </summary>
			public FDK.カウンタ.単純増加後不変カウンタ 進行カウンタ;

			/// <summary>
			/// 現在表示中のヒット判定種別。
			/// 進行カウンタが動作中のときのみ有効。
			/// </summary>
			public ヒット判定種別 ヒット判定種別;

			public bool 判定対象である;
			public float 中央Y位置dpx;

			public float X方向拡大率;
			public float Y方向拡大率;
			public float 相対X座標dpx;
			public float 相対Y座標dpx;
			public float 透明度0to1;

			public 進行描画コンテキスト()
			{
				this.初期化する();
			}
			public void 初期化する()
			{
				this.進行カウンタ = new FDK.カウンタ.単純増加後不変カウンタ();
				this.ヒット判定種別 = ヒット判定種別.AUTO;

				this.判定対象である = true;
				this.中央Y位置dpx = 0.0f;

				this.X方向拡大率 = 1.0f;
				this.Y方向拡大率 = 1.0f;
				this.相対X座標dpx = 0.0f;
				this.相対Y座標dpx = 0.0f;
				this.透明度0to1 = 1.0f;
			}
		}

		private Dictionary<ヒットレーン種別, 進行描画コンテキスト> _ヒット判定レーンto進行描画コンテキスト = null;

		private readonly Dictionary<ヒット判定種別, FDK.メディア.画像> _文字列画像 = new Dictionary<ヒット判定種別, 画像>() {
			{ ヒット判定種別.PERFECT, new 画像( @"$(Static)\images\Judge Perfect.png" ) },
			{ ヒット判定種別.GREAT, new 画像( @"$(Static)\images\Judge Great.png" ) },
			{ ヒット判定種別.GOOD, new 画像( @"$(Static)\images\Judge Good.png" ) },
			{ ヒット判定種別.POOR, new 画像( @"$(Static)\images\Judge Poor.png" ) },
			{ ヒット判定種別.MISS, new 画像( @"$(Static)\images\Judge Miss.png" ) },
			{ ヒット判定種別.AUTO, new 画像( @"$(Static)\images\Judge Auto.png" ) },
		};

		private readonly object _スレッド間同期 = new object();
	}
}
