﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.演奏
{
	class スクロール譜面 : FDK.Activity
	{
		public Action<SSTFormat.チップ種別, ヒット判定種別> ヒット判定文字列開始 = null;

		public Action コンボリセット = null;

		public Action コンボ加算 = null;

		public Action<ヒット判定種別> ヒット判定数加算 = null;

		public Func<double> 背景動画の長さsec = null;

		public Action<double> 背景動画再生開始 = null;

		public Action<SSTFormat.チップ> チップヒット = null;

		public Action ステージクリア = null;

		public Func<double> リアルタイム演奏時刻sec = null;

		public Func<double> 譜面スクロール速度の倍率 = null;

		public Action FPSをカウント = null;

		public スクロール譜面()
		{
			this.子リスト.Add( this._チップ画像 = new 画像( @"$(Static)\images\Chips.png" ) );
			this.子リスト.Add( this._コンソールフォント = new コンソールフォント() );
		}

		protected override void On活性化( デバイスリソース dr )
		{
			this._描画開始チップ番号 = -1;
			this._チップ画像の矩形リスト = new FDK.メディア.矩形リスト( @"$(Static)\images\Chips Rectangle List.xml" );   // ここで読み込む → 変更があったら反映される（デバッグ用途）。
			var ユーザ = StrokeStyleT.ユーザ管理.現在選択されているユーザ;
			this._ヒット判定を行うチップと対応するレーン = new Dictionary<SSTFormat.チップ種別, ヒットレーン種別>() {
				{ SSTFormat.チップ種別.LeftCrash, ヒットレーン種別.LeftCrash },
				{ SSTFormat.チップ種別.Ride, ( ユーザ.Rideは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.Ride_Cup, ( ユーザ.Rideは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.China, ( ユーザ.Chinaは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.Splash, ( ユーザ.Splashは左 ) ? ヒットレーン種別.LeftCrash : ヒットレーン種別.RightCrash },
				{ SSTFormat.チップ種別.HiHat_Open, ヒットレーン種別.HiHat },
				{ SSTFormat.チップ種別.HiHat_HalfOpen, ヒットレーン種別.HiHat },
				{ SSTFormat.チップ種別.HiHat_Close, ヒットレーン種別.HiHat },
				//{ SSTFormat.チップ種別.HiHat_Foot, ヒット判定レーン種別.HiHat },
				{ SSTFormat.チップ種別.Snare, ヒットレーン種別.Snare },
				{ SSTFormat.チップ種別.Snare_OpenRim, ヒットレーン種別.Snare },
				{ SSTFormat.チップ種別.Snare_ClosedRim, ヒットレーン種別.Snare },
				//{ SSTFormat.チップ種別.Snare_Ghost, ヒット判定レーン種別.Snare },
				{ SSTFormat.チップ種別.Bass, ヒットレーン種別.Bass },
				{ SSTFormat.チップ種別.Tom1, ヒットレーン種別.Tom1 },
				{ SSTFormat.チップ種別.Tom1_Rim, ヒットレーン種別.Tom1 },
				{ SSTFormat.チップ種別.Tom2, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom2_Rim, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom3, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.Tom3_Rim, ヒットレーン種別.Tom2 },
				{ SSTFormat.チップ種別.RightCrash, ヒットレーン種別.RightCrash },
			};
			this._活性化した直後である = true;
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			if( null != this._高頻度進行タスクへのイベント )
			{
				// 高頻度進行スレッドへ、終了を指示。
				this._高頻度進行タスクへのイベント.現在の状態 = FDK.同期.TriStateEvent.状態種別.OFF;

				// スレッドが終了するまで（状態が無効にされるまで）待つ必要はない。
				//this._高頻度進行タスクへのイベント.無効になるまでブロックする();
			}
		}

		protected override void Onデバイス依存リソースの作成( デバイスリソース dr )
		{
			this._画面の高さdpx = dr.設計画面サイズdpx.Height;
		}

		public double 演奏開始小節番号を設定しその時刻secを返す( int 演奏開始小節番号 )
		{
			var スコア = StrokeStyleT.演奏スコア;

			if( null == スコア )
				return 0.0;

			double 演奏開始時刻sec = 0.0;
			for( int i = 0; i < スコア.チップリスト.Count; i++ )
			{
				if( スコア.チップリスト[ i ].小節番号 < 演奏開始小節番号 )
				{
					スコア.チップリスト[ i ].ヒット済みの状態にする();
				}
				else
				{
					this._描画開始チップ番号 = i;
					演奏開始時刻sec = スコア.チップリスト[ i ].発声時刻sec;

					#region " 演奏開始時刻sec を少し早めに設定する。"
					//----------------
					演奏開始時刻sec -= 0.5;

					for( int j = i; j >= 0; j-- )
					{
						if( スコア.チップリスト[ j ].ヒット済みである )
							スコア.チップリスト[ j ].ヒット前の状態にする();
					}
					//----------------
					#endregion

					break;
				}
			}

			return 演奏開始時刻sec;
		}

		public void 再生中の時刻なら動画とBGMを再生開始する( double 時刻sec )
		{
			FDK.Log.BeginInfo( $"{FDK.Utilities.現在のメソッド名}" );

			try
			{
				FDK.Log.Info( $"現在の時刻sec = {時刻sec}" );

				var スコア = StrokeStyleT.演奏スコア;

				if( null == スコア )
				{
					FDK.Log.Info( "演奏スコアが未設定です。" );
					return;
				}

				foreach( var チップ in スコア.チップリスト )
				{
					if( チップ.チップ種別 == SSTFormat.チップ種別.背景動画 )
					{
						double 背景動画の長さsec = this.背景動画の長さsec();

						FDK.Log.Info( $"背景動画の発生時刻sec:{チップ.発声時刻sec}" );
						FDK.Log.Info( $"背景動画の長さsec:{背景動画の長さsec}" );

						if( ( チップ.発声時刻sec <= 時刻sec ) &&
							( 時刻sec < ( チップ.発声時刻sec + 背景動画の長さsec ) ) )
						{
							double 再生開始時刻sec = 時刻sec - チップ.発声時刻sec;
							this.背景動画再生開始( 再生開始時刻sec );

							FDK.Log.Info( $"背景動画の再生を開始しました。（再生開始時刻sec={再生開始時刻sec}）" );
						}
						else
						{
							FDK.Log.Info( $"背景動画は再生中ではないので何もしません。" );
						}
						return;
					}
				}

				FDK.Log.Info( $"背景動画は存在しません。" );
			}
			finally
			{
				FDK.Log.EndInfo( $"{FDK.Utilities.現在のメソッド名}" );
			}
		}

		public void 演奏を停止する()
		{
			this._描画開始チップ番号 = -1;
		}

		public void 小節線拍線を進行描画する( デバイスリソース dr, double 現在の演奏時刻sec )
		{
			this._画面内に収まるチップをすべて進行描画する(
				dr,
				this._小節線拍線を１つ描画する,
				現在の演奏時刻sec );
		}

		public void チップを進行描画する( デバイスリソース dr, double 現在の演奏時刻sec )
		{
			this._画面内に収まるチップをすべて進行描画する(
				dr,
				this._チップを１つ描画する,
				現在の演奏時刻sec );
		}

		private bool _活性化した直後である = false;

		/// <summary>
		///		演奏スコア.チップリスト[] のうち、描画を始めるチップのインデックス番号を示す。
		///		演奏開始直後は 0 で始まり、対象番号のチップが描画範囲を流れ去るたびに +1 される。
		///		未演奏時・演奏終了時は -1 。
		/// </summary>
		private int _描画開始チップ番号 = -1;

		private FDK.メディア.画像 _チップ画像 = null;

		private FDK.メディア.矩形リスト _チップ画像の矩形リスト = null;

		private Dictionary<SSTFormat.チップ種別, ヒットレーン種別> _ヒット判定を行うチップと対応するレーン = null;

		private FDK.カウンタ.単純増加後反復カウンタ _チップアニメ = new FDK.カウンタ.単純増加後反復カウンタ();

		private SST.ステージ.コンソールフォント _コンソールフォント = null;

		private readonly Dictionary<SSTFormat.レーン種別, float> _レーン種別toレーンフレーム左端からの相対X位置dpx = new Dictionary<SSTFormat.レーン種別, float>() {
			{ SSTFormat.レーン種別.LeftCrash, +36f },
			{ SSTFormat.レーン種別.HiHat, +105f },
			{ SSTFormat.レーン種別.Foot, +145f },
			{ SSTFormat.レーン種別.Snare, +214f },
			{ SSTFormat.レーン種別.Tom1, +310f },
			{ SSTFormat.レーン種別.Bass, +381f },
			{ SSTFormat.レーン種別.Tom2, +448f },
			{ SSTFormat.レーン種別.Tom3, +544f },
			{ SSTFormat.レーン種別.RightCrash, +632f },
		};

		private float _画面の高さdpx = 0f;    // 進行スレッドからはデバイスリソースを参照しないので、ここにキャッシュしておく。

		private FDK.同期.TriStateEvent _高頻度進行タスクへのイベント = null;

		private readonly object _スレッド間同期 = new object();

		private void _画面内に収まるチップをすべて進行描画する( デバイスリソース dr, Action<デバイスリソース, SSTFormat.チップ, float> 描画アクション, double 現在の演奏時刻sec )
		{
			lock( this._スレッド間同期 )
			{
				var 演奏スコア = StrokeStyleT.演奏スコア;

				if( null == 演奏スコア )
					return;

				#region " 最初の進行描画。"
				//----------------
				if( this._活性化した直後である )
				{
					this._活性化した直後である = false;
					this._描画開始チップ番号 = 0; // -1 → 0; 演奏開始。
					this._チップアニメ.開始する( 最初の値: 0, 最後の値: 48, 値をひとつ増加させるのにかける時間ms: 10 );

					this._高頻度進行タスクへのイベント = new FDK.同期.TriStateEvent( FDK.同期.TriStateEvent.状態種別.ON );

					// 高頻度進行タスクを生成。
					System.Threading.Tasks.Task.Run( () => {
						this._高頻度進行処理タスクエントリ();
					} );
				}
				//----------------
				#endregion

				for( int i = this._描画開始チップ番号; ( 0 <= i ) && ( 演奏スコア.チップリスト.Count > i ); i++ )
				{
					var チップ = 演奏スコア.チップリスト[ i ];

					// 時間差を算出する。
					double 描画時間差sec = 現在の演奏時刻sec - チップ.描画時刻sec;

					// 判定バーとチップの距離[dpx;符号付き;負数ならバー未達、0でバー直上、正数でバー通過]を算出する。
					double 描画距離dpx = 演奏スコア.指定された時間secに対応する符号付きピクセル数を返す( this.譜面スクロール速度の倍率(), 描画時間差sec );

					// チップのY座標を算出し、ループの終了判定を行う。
					double y = 座標.判定バーの中央Y座標dpx + 描画距離dpx;
					if( y < -40.0 )   // y が画面上端より上に出ていればそこでチップのループ描画は終了。-40dpx はチップが隠れるであろう適当なマージン。
						break;

					#region " チップが描画開始チップであり、かつ、そのY座標が画面下端を超えたなら、描画開始チップ番号を更新する。"
					//----------------
					if( ( this._描画開始チップ番号 == i ) && ( this._画面の高さdpx + 40.0 < y ) )   // +40 dpx はチップが（以下同上
					{
						this._描画開始チップ番号++;
						if( 演奏スコア.チップリスト.Count <= this._描画開始チップ番号 )
						{
							this.ステージクリア();
							this._描画開始チップ番号 = -1;    // 演奏終了。
						}
					}
					//----------------
					#endregion

					// チップを１つ描画する。
					if( チップ.可視 )
						描画アクション( dr, チップ, (float) y );

					// 小節の先頭の場合。
					if( チップ.チップ種別 == SSTFormat.チップ種別.小節の先頭 )
					{
						#region " 小節番号を表示する。"
						//----------------
						string 小節番号文字列 = $"{チップ.小節番号}";

						float 左位置dpx = 座標.レーンフレーム左端のX座標dpx
							+ this._レーン種別toレーンフレーム左端からの相対X位置dpx[ SSTFormat.レーン種別.LeftCrash ]
							- 小節番号文字列.Length * this._コンソールフォント.文字幅dpx // 右そろえ
							- 10f;	// LeftCrash からのマージン

						float 上位置dpx = (float) y - this._コンソールフォント.改行幅dpx;

						this._コンソールフォント.描画する( dr, 左位置dpx, 上位置dpx, 小節番号文字列 );
						//----------------
						#endregion
					}
				}
			}
		}

		/// <summary>
		///		音声の再生と演奏用入力は、描画処理とは並行して、高頻度に行う。
		/// </summary>
		private void _高頻度進行処理タスクエントリ()
		{
			FDK.Log.Info( $"{FDK.Utilities.現在のメソッド名} --> 開始" );

			while( this._高頻度進行タスクへのイベント.現在の状態 == FDK.同期.TriStateEvent.状態種別.ON )
			{
				lock( this._スレッド間同期 )
				{
					this.FPSをカウント();

					var 演奏スコア = StrokeStyleT.演奏スコア;

					if( null != 演奏スコア )
					{
						for( int i = this._描画開始チップ番号; ( 0 <= i ) && ( 演奏スコア.チップリスト.Count > i ); i++ )
						{
							var チップ = 演奏スコア.チップリスト[ i ];

							// 時間差を算出する。
							double 描画時間差sec = this.リアルタイム演奏時刻sec() - チップ.描画時刻sec;

							// 判定バーとチップの距離[dpx;符号付き;負数ならバー未達、0でバー直上、正数でバー通過]を算出する。
							double 描画距離dpx = 演奏スコア.指定された時間secに対応する符号付きピクセル数を返す( this.譜面スクロール速度の倍率(), 描画時間差sec );

							// チップのY座標を算出し、ループの終了判定を行う。
							double y = 座標.判定バーの中央Y座標dpx + 描画距離dpx;
							if( y < -40.0 )   // y が画面上端より上に出ていればそこでチップのループ描画は終了。-40dpx はチップが隠れるであろう適当なマージン。
								break;

							this._AutoPlayチップ判定を行う( チップ, 描画距離dpx );
							this._Miss判定を行う( チップ, 描画時間差sec );
						}
					}
				}

				// ウェイト
				System.Threading.Thread.Sleep( 1 );
			}

			this._高頻度進行タスクへのイベント.現在の状態 = FDK.同期.TriStateEvent.状態種別.無効;

			FDK.Log.Info( $"{FDK.Utilities.現在のメソッド名} <-- 終了" );
		}

		private void _AutoPlayチップ判定を行う( SSTFormat.チップ chip, double 描画距離dpx )
		{
			if( ( chip.ヒットされていない ) &&    // チップが未ヒット、かつ、
				( StrokeStyleT.ユーザ管理.現在選択されているユーザ.チップが自動演奏である( chip.チップ種別 ) ) &&    // チップの AutoPlay が ON、かつ、
				( 0 <= 描画距離dpx ) )  // バーを通過した。
			{
				chip.ヒット済みである = true;
				chip.不可視 = true;
				if( chip.チップ種別 == SSTFormat.チップ種別.背景動画 )
				{
					// (A) 背景動画の場合。
					this.背景動画再生開始?.Invoke( 0.0 );
				}
				else
				{
					// (B) その他のチップの場合。
					this.チップヒット?.Invoke( chip );
					this.コンボ加算?.Invoke();
					this.ヒット判定数加算?.Invoke( ヒット判定種別.AUTO );
					this.ヒット判定文字列開始?.Invoke( chip.チップ種別, ヒット判定種別.AUTO );
				}
			}
		}

		private void _Miss判定を行う( SSTFormat.チップ chip, double 描画時間差sec )
		{
			if( ( chip.ヒットされていない ) &&    // チップが未ヒット、かつ、
				( this._ヒット判定を行うチップと対応するレーン.ContainsKey( chip.チップ種別 ) ) && // チップがヒット判定対象である、かつ、
				( 描画時間差sec > StrokeStyleT.ユーザ管理.現在選択されているユーザ.ヒット範囲sec.Poor ) )  // 描画時間差が Poor 範囲を超えている。
			{
				chip.ヒット済みである = true;
				chip.不可視 = true;
				this.コンボリセット?.Invoke();
				this.ヒット判定文字列開始?.Invoke( chip.チップ種別, ヒット判定種別.MISS );
			}
		}

		private void _小節線拍線を１つ描画する( デバイスリソース dr, SSTFormat.チップ chip, float Ydpx )
		{
			if( null == this._チップ画像 )
				return;

			this._チップ画像.加算合成 = false;

			switch( chip.チップ種別 )
			{
				case SSTFormat.チップ種別.小節線:
					#region " 小節線を１本表示する。"
					//----------------
					{
						float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this._レーン種別toレーンフレーム左端からの相対X位置dpx[ SSTFormat.レーン種別.LeftCrash ] - 1f;
						float 上位置dpx = Ydpx - 1f;
						var 画像範囲orNull = this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.小節線 ) ];
						if( null != 画像範囲orNull )
						{
							var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;
							this._チップ画像.描画する( dr, 左位置dpx, 上位置dpx, 転送元矩形dpx: 画像範囲 );
							this._チップ画像.描画する( dr, 左位置dpx + 画像範囲.Width, 上位置dpx, 転送元矩形dpx: 画像範囲 );
						}
					}
					//----------------
					#endregion
					break;

				case SSTFormat.チップ種別.拍線:
					#region " 拍線を１本表示する。"
					//----------------
					{
						float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this._レーン種別toレーンフレーム左端からの相対X位置dpx[ SSTFormat.レーン種別.LeftCrash ] - 1f;
						float 上位置dpx = Ydpx;
						var 画像範囲orNull = this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.拍線 ) ];
						if( null != 画像範囲orNull )
						{
							var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;
							this._チップ画像.描画する( dr, 左位置dpx: 左位置dpx, 上位置dpx: 上位置dpx, 転送元矩形dpx: 画像範囲 );
							this._チップ画像.描画する( dr, 左位置dpx: 左位置dpx + 画像範囲.Width, 上位置dpx: 上位置dpx, 転送元矩形dpx: 画像範囲 );
						}
					}
					//----------------
					#endregion
					break;
			}
		}

		private void _チップを１つ描画する( デバイスリソース dr, SSTFormat.チップ chip, float Ydpx )
		{
			if( null == this._チップ画像 )
				return;

			this._チップ画像.加算合成 = false;
			float 音量0to1 = chip.音量 * 0.25f; // 1～4 → 0.25～1.00

			switch( chip.チップ種別 )
			{
				#region " LeftCrash "
				//----------------
				case SSTFormat.チップ種別.LeftCrash:
					this._単画チップを１つ描画する(
						dr,
						SSTFormat.レーン種別.LeftCrash,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.LeftCrash ) ],
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion

				#region " HiHat_Close "
				//----------------
				case SSTFormat.チップ種別.HiHat_Close:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.HiHat,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ],
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion
				#region " HiHat_HalfOpen "
				//----------------
				case SSTFormat.チップ種別.HiHat_HalfOpen:
					this._アニメチップを１つ描画する( 
						dr,
						SSTFormat.レーン種別.HiHat,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ],
						Ydpx, 
						音量0to1 );
					this._単画チップを１つ描画する( 
						dr, 
						SSTFormat.レーン種別.Foot, 
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_HalfOpen ) ],
						Ydpx, 
						1.0f );    // 音量は反映しない
					break;
				//----------------
				#endregion
				#region " HiHat_Open "
				//----------------
				case SSTFormat.チップ種別.HiHat_Open:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.HiHat,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Close ) ],
						Ydpx, 
						音量0to1 );
					this._単画チップを１つ描画する( dr, SSTFormat.レーン種別.Foot, this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Open ) ], Ydpx, 1.0f );    // 音量は反映しない
					break;
				//----------------
				#endregion
				#region " HiHat_Foot "
				//----------------
				case SSTFormat.チップ種別.HiHat_Foot:
					this._単画チップを１つ描画する( 
						dr, 
						SSTFormat.レーン種別.Foot, 
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.HiHat_Foot ) ],
						Ydpx,
						1.0f );    // 音量は反映しない
					break;
				//----------------
				#endregion
				
				#region " Snare "
				//----------------
				case SSTFormat.チップ種別.Snare:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.Snare,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare ) ], 
						Ydpx, 
						音量0to1 );
					break;
				//----------------
				#endregion
				#region " Snare_ClosedRim "
				//----------------
				case SSTFormat.チップ種別.Snare_ClosedRim:
					this._単画チップを１つ描画する(
						dr, 
						SSTFormat.レーン種別.Snare,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_ClosedRim ) ], 
						Ydpx,
						1.0f );  // 音量は反映しない
					break;
				//----------------
				#endregion
				#region " Snare_OpenRim "
				//----------------
				case SSTFormat.チップ種別.Snare_OpenRim:
					this._単画チップを１つ描画する( 
						dr,
						SSTFormat.レーン種別.Snare,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_OpenRim ) ], 
						Ydpx,
						音量0to1 );
					// ↓ないほうがいいかも。
					//this._単画チップを１つ描画する(
					//	dr,
					//	SSTFormat.レーン種別.Snare,
					//	this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare ) ],
					//	Ydpx,
					//	音量0to1 ); 
					break;
				//----------------
				#endregion
				#region " Snare_Ghost "
				//----------------
				case SSTFormat.チップ種別.Snare_Ghost:
					this._単画チップを１つ描画する( 
						dr, 
						SSTFormat.レーン種別.Snare,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Snare_Ghost ) ], 
						Ydpx,
						1.0f );  // 音量は反映しない
					break;
				//----------------
				#endregion

				#region " Bass "
				//----------------
				case SSTFormat.チップ種別.Bass:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.Bass,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Bass ) ],
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion

				#region " Tom1 "
				//----------------
				case SSTFormat.チップ種別.Tom1:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.Tom1,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom1 ) ], 
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion
				#region " Tom1_Rim "
				//----------------
				case SSTFormat.チップ種別.Tom1_Rim:
					this._単画チップを１つ描画する(
						dr, 
						SSTFormat.レーン種別.Tom1, 
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom1_Rim ) ], 
						Ydpx,
						1.0f );  // 音量は反映しない
					break;
				//----------------
				#endregion
				#region " Tom2 "
				//----------------
				case SSTFormat.チップ種別.Tom2:
					this._アニメチップを１つ描画する( 
						dr,
						SSTFormat.レーン種別.Tom2,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom2 ) ], 
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion
				#region " Tom2_Rim "
				//----------------
				case SSTFormat.チップ種別.Tom2_Rim:
					this._単画チップを１つ描画する( 
						dr, 
						SSTFormat.レーン種別.Tom2, 
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom2_Rim ) ],
						Ydpx, 
						1.0f );  // 音量は反映しない
					break;
				//----------------
				#endregion
				#region " Tom3 "
				//----------------
				case SSTFormat.チップ種別.Tom3:
					this._アニメチップを１つ描画する(
						dr,
						SSTFormat.レーン種別.Tom3,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom3 ) ], 
						Ydpx, 
						音量0to1 );
					break;
				//----------------
				#endregion
				#region " Tom3_Rim "
				//----------------
				case SSTFormat.チップ種別.Tom3_Rim:
					this._単画チップを１つ描画する(
						dr,
						SSTFormat.レーン種別.Tom3,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.Tom3_Rim ) ], 
						Ydpx,
						1.0f );  // 音量は反映しない
					break;
				//----------------
				#endregion

				#region " RightCrash "
				//----------------
				case SSTFormat.チップ種別.RightCrash:
					this._単画チップを１つ描画する( 
						dr, 
						SSTFormat.レーン種別.RightCrash,
						this._チップ画像の矩形リスト[ nameof( SSTFormat.チップ種別.RightCrash ) ],
						Ydpx,
						音量0to1 );
					break;
				//----------------
				#endregion

				#region " China "
				//----------------
				case SSTFormat.チップ種別.China:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Chinaは左 )
					{
						this._単画チップを１つ描画する(
							dr,
							SSTFormat.レーン種別.LeftCrash,
							this._チップ画像の矩形リスト[ "LeftChina" ],
							Ydpx,
							音量0to1 );
					}
					else
					{
						this._単画チップを１つ描画する( 
							dr, 
							SSTFormat.レーン種別.RightCrash, 
							this._チップ画像の矩形リスト[ "RightChina" ],
							Ydpx,
							音量0to1 );
					}
					break;
				//----------------
				#endregion
				#region " Ride "
				//----------------
				case SSTFormat.チップ種別.Ride:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Rideは左 )
					{
						this._単画チップを１つ描画する(
							dr,
							SSTFormat.レーン種別.LeftCrash,
							this._チップ画像の矩形リスト[ "LeftRide" ],
							Ydpx,
							音量0to1 );
					}
					else
					{
						this._単画チップを１つ描画する(
							dr,
							SSTFormat.レーン種別.RightCrash,
							this._チップ画像の矩形リスト[ "RightRide" ], 
							Ydpx, 
							音量0to1 );
					}
					break;
				//----------------
				#endregion
				#region " Ride_Cup "
				//----------------
				case SSTFormat.チップ種別.Ride_Cup:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Rideは左 )
					{
						this._単画チップを１つ描画する(
							dr,
							SSTFormat.レーン種別.LeftCrash,
							this._チップ画像の矩形リスト[ "LeftRide_Cup" ],
							Ydpx,
							音量0to1 );
					}
					else
					{
						this._単画チップを１つ描画する( 
							dr, 
							SSTFormat.レーン種別.RightCrash, 
							this._チップ画像の矩形リスト[ "RightRide_Cup" ], 
							Ydpx,
							音量0to1 );
					}
					break;
				//----------------
				#endregion
				#region " Splash "
				//----------------
				case SSTFormat.チップ種別.Splash:
					if( StrokeStyleT.ユーザ管理.現在選択されているユーザ.Splashは左 )
					{
						this._単画チップを１つ描画する(
							dr,
							SSTFormat.レーン種別.LeftCrash,
							this._チップ画像の矩形リスト[ "LeftSplash" ],
							Ydpx,
							音量0to1 );
					}
					else
					{
						this._単画チップを１つ描画する( 
							dr,
							SSTFormat.レーン種別.RightCrash,
							this._チップ画像の矩形リスト[ "RightSplash" ],
							Ydpx, 
							音量0to1 );
					}
					break;
				//----------------
				#endregion

				#region " LeftCymbal_Mute "
				//----------------
				case SSTFormat.チップ種別.LeftCymbal_Mute:
					this._単画チップを１つ描画する(
						dr,
						SSTFormat.レーン種別.LeftCrash,
						this._チップ画像の矩形リスト[ "LeftCymbal_Mute" ],
						Ydpx,
						1.0f );	// 音量は反映しない
					break;
				//----------------
				#endregion
				#region " RightCymbal_Mute "
				//----------------
				case SSTFormat.チップ種別.RightCymbal_Mute:
					this._単画チップを１つ描画する(
						dr,
						SSTFormat.レーン種別.RightCrash,
						this._チップ画像の矩形リスト[ "RightCymbal_Mute" ],
						Ydpx,
						1.0f ); // 音量は反映しない
					break;
				//----------------
				#endregion
			}
		}

		private void _アニメチップを１つ描画する( デバイスリソース dr, SSTFormat.レーン種別 elane, SharpDX.RectangleF? 画像範囲orNull, float Ydpx, float 音量0to1 )
		{
			if( null == 画像範囲orNull )
				return;
			var 画像範囲 = (SharpDX.RectangleF) 画像範囲orNull;

			float チップ1枚の高さdpx = 18f;
			画像範囲.Offset( 0f, this._チップアニメ.現在値 * 15f );   // 下端3dpxは下のチップと共有する前提のデザインなので、18f-3f = 15f。
			画像範囲.Height = チップ1枚の高さdpx;
			float 左位置dpx = 座標.レーンフレーム左端のX座標dpx + this._レーン種別toレーンフレーム左端からの相対X位置dpx[ elane ] - 画像範囲.Width / 2f;
			float 上位置dpx = Ydpx - ( チップ1枚の高さdpx / 2f ) * 音量0to1;

			this._チップ画像.描画する( dr, 左位置dpx, 上位置dpx, 転送元矩形dpx: 画像範囲, Y方向拡大率: 音量0to1 );
		}

		private void _単画チップを１つ描画する( デバイスリソース dr, SSTFormat.レーン種別 eLane, SharpDX.RectangleF? 元矩形dpx, float 上位置dpx, float 音量0to1 )
		{
			if( null == 元矩形dpx )
				return;

			var 画像範囲dpx = (SharpDX.RectangleF) 元矩形dpx;
			this._チップ画像.描画する(
				dr,
				左位置dpx: 座標.レーンフレーム左端のX座標dpx + this._レーン種別toレーンフレーム左端からの相対X位置dpx[ eLane ] - ( 画像範囲dpx.Width / 2f ),
				上位置dpx: 上位置dpx - ( ( 画像範囲dpx.Height / 2f ) * 音量0to1 ),
				転送元矩形dpx: 元矩形dpx,
				Y方向拡大率: 音量0to1 );
		}
	}
}
