﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using FDK.メディア;

namespace SST.ステージ.ログイン
{
	/// <remarks>
	/// 入力：
	/// 　なし
	/// 出力：
	/// 　(A) ユーザが選択された場合
	/// 　　　this.現在のフェーズ								← 確定
	/// 　　　StrokeStyleT.ユーザ管理.現在選択されているユーザ	← ログインしたユーザのユーザオブジェクト
	/// 　　　
	/// 　(B) キャンセルされた場合
	/// 　　　this.現在のフェーズ								← キャンセル
	/// 　　　StrokeStyleT.ユーザ管理.現在選択されているユーザ	← null
	/// </remarks>
	class ログインステージ : SST.ステージ.ステージ
	{
		public enum フェーズ
		{
			初期状態,
			表示中,
			確定,
			キャンセル,
		}

		public フェーズ 現在のフェーズ { get; protected set; } = フェーズ.初期状態;

		public ログインステージ()
		{
			this.子リスト.Add( this._ログイン画面見出し = new 文字列画像( "ユーザ選択" ) );
		}

		protected override void On活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "ログインステージを開始します。" );

			this.現在のフェーズ = フェーズ.表示中;

			// ユーザ数分のユーザパネルを作成し、活性化する。
			this._ユーザパネル = new List<文字列画像>();
			var ユーザリスト = StrokeStyleT.ユーザ管理.ユーザリスト;
			for( int i = 0; i < ユーザリスト.Count; i++ ) // ユーザの選択はインデックスで行うが、IEnumerator が List 順に返すという保証はないので、ここでは念のため foreach は使わない。
			{
				var user = ユーザリスト[ i ];
				var panel = new 文字列画像( user.名前 );
				this._ユーザパネル.Add( panel );
				this.子リスト.Add( panel );	// 子リストに追加
			}

			StrokeStyleT.ユーザ管理.最初のユーザを選択する();
		}

		protected override void On非活性化( デバイスリソース dr )
		{
			FDK.Log.Info( "ログインステージを終了します。" );

			foreach( var panel in this._ユーザパネル )
				this.子リスト.Remove( panel );  // 子リストから削除
			this._ユーザパネル.Clear();
		}

		public override void 進行描画する( デバイスリソース dr )
		{
			if( this.現在のフェーズ != フェーズ.表示中 )
				return;

#if ユーザ選択画面が実装できてる
			// 描画。

			// 見出し
			this.ログイン画面見出し.進行描画する( dr, 0.0f, 0.0f );

			// ユーザ名一覧
			for( int i = 0; i < this.ユーザパネル.Count; i++ )
			{
				this.ユーザパネル[ i ].進行描画する(
					dr,
					( i == this.ユーザインデックス ) ? 20.0f : 10.0f, 
					50.0f + 50.0f * i );
			}
			
			// 入力。

			StrokeStyleT.すべての入力デバイスをポーリングする();

			// Enter 押下 → ユーザ名を確定する。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Return ) )
			{
				this.現在のフェーズ = フェーズ.確定;
			}

			// Esc 押下 → ユーザ選択操作をキャンセルする。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Escape ) )
			{
				FDK.Log.Info( "ユーザ選択操作がキャンセルされました。" );
				StrokeStyleT.ユーザ管理.ユーザを選択する( 選択対象ユーザ: null );
				this.現在のフェーズ = フェーズ.キャンセル;
			}

			// 下矢印 押下 → 次のユーザを選択する。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Down ) )
			{
				this.ユーザインデックス = Math.Min( this.ユーザインデックス + 1, this.ユーザパネル.Count - 1 );
			}
			
			// 上矢印 押下 → 前のユーザを選択する。
			if( StrokeStyleT.キーボード入力.キーが押された( SharpDX.DirectInput.Key.Up ) )
			{
				this.ユーザインデックス = Math.Max( this.ユーザインデックス - 1, 0 );
			}
#else
#warning ユーザ選択画面が完成するまでは、AutoPlayer で自動的にログインするようにする。
			StrokeStyleT.ユーザ管理.ユーザを選択する( Properties.Resources.AUTOPLAYER );
			this.現在のフェーズ = フェーズ.確定;
			return;
#endif
		}

		private List<FDK.メディア.文字列画像> _ユーザパネル = null;

		private FDK.メディア.文字列画像 _ログイン画面見出し = null;
	}
}
