﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Runtime.Serialization;
using FDK;

namespace SST.設定
{
	/// <summary>
	///		ユーザの基本情報。
	/// </summary>
	/// <remarks>
	///		ユーザクラスを <see cref="FDK.Activity"/> から派生可能にするため、DataContract 部分をこのクラスに抽出。
	/// </remarks>
	[DataContract( Name = "Properties", Namespace = "" )]
	class ユーザプロパティ : IExtensibleDataObject
	{
		/// <summary>
		///		ユーザ名。
		/// </summary>
		[DataMember]
		public string 名前 { get; set; }

		/// <summary>
		///		ユーザの写真への相対パス。ユーザフォルダが基準。
		/// </summary>
		[DataMember]
		public string 写真パス { get; set; }

		/// <summary>
		///		曲を検索したいフォルダのパスのリスト。
		/// </summary>
		/// <remarks>
		///		ビュアーモードでログインしているユーザの場合は空リスト。
		/// </remarks>
		[DataMember]
		public List<string> 曲検索フォルダパスリスト { get; set; }


		public ユーザプロパティ()
		{
			this._既定値で初期化する( new StreamingContext() );
		}


		/// <summary>
		///		コンストラクタ時、または逆シリアル化時のメンバの既定値を設定する。
		/// </summary>
		/// <param name="sc">未使用。</param>
		/// <remarks>
		///		.NET 既定の初期値だと支障のある（逆シリアル化対象の）メンバがあれば、ここで初期化しておくこと。
		/// </remarks>
		[OnDeserializing]
		private void _既定値で初期化する( StreamingContext sc )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.名前 = "(no name)";
				this.写真パス = "photo.jpg";
				this.曲検索フォルダパスリスト = new List<string>() { @"$(Exe)\Songs" };      // 既定の検索パス
			}
		}

		#region " IExtensibleDataObject の実装 "
		//----------------
		private ExtensionDataObject _ExData;

		public virtual ExtensionDataObject ExtensionData
		{
			get
				=> this._ExData;

			set
				=> this._ExData = value;
		}
		//----------------
		#endregion
	}
}
