﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SSTFormat.v3;
using FDK;
using FDK.メディア;
using SST.曲;

namespace SST.ステージ.曲読込
{
	class 曲読込ステージ : ステージ
	{
		public enum フェーズ
		{
			開始,
			完了,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public 曲読込ステージ()
		{
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				if( App.ビュアーモードではない )
					Trace.Assert( App.ユーザ管理.選択されているユーザ.曲ツリー.フォーカスノード is MusicNode );

				this.現在のフェーズ = フェーズ.開始;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );

			switch( this.現在のフェーズ )
			{
				case フェーズ.開始:
					#region " *** "
					//----------------
					{
						var node = ( App.ビュアーモードではない ) ?
							(MusicNode) App.ユーザ管理.選択されているユーザ.曲ツリー.フォーカスノード :    // (A) 通常モード
							App.ビュアー用ノード;                                                        // (B) ビュアーモード時

						string 選択曲ファイルパス = node.曲ファイルパス;
						Trace.Assert( 選択曲ファイルパス.Nullでも空でもない() );

						using( Log.Block( "曲の読み込み" ) )
						{
							// スコアを読み込む。
							App.演奏スコア = new スコア( SST.IO.Folder.絶対パスに含まれるフォルダ変数を展開して返す( 選択曲ファイルパス ) );

							#region " サウンドデバイス遅延を取得し、全チップの発声時刻へ反映する。"
							//----------------
							float 再生時遅延ms = (float) ( App.サウンドデバイス.再生遅延sec * 1000.0 );

							foreach( var chip in App.演奏スコア.チップリスト )
								chip.発声時刻ms -= (long) 再生時遅延ms;
							//----------------
							#endregion

							this.現在のフェーズ = フェーズ.完了;
						}
					}
					//----------------
					#endregion
					break;

				case フェーズ.完了:
					break;
			}
		}
	}
}
