﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using SharpDX.DirectInput;
using FDK;
using FDK.メディア;
using FDK.カウンタ;
using SST.入力;

namespace SST.ステージ.タイトル
{
	class タイトルステージ : ステージ
	{
		public enum フェーズ
		{
			表示,
			確定,
			キャンセル,
		}

		public フェーズ 現在のフェーズ
		{
			get;
			protected set;
		}


		public タイトルステージ()
		{
			this.子リスト.Add( this._背景画像 = new 画像( @"$(System)images\タイトル画面.jpg" ) );
			this.子リスト.Add( this._FPS = new FPS() );
		}

		protected override void On活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
				this.現在のフェーズ = フェーズ.表示;
			}
		}

		protected override void On非活性化( グラフィックデバイス gd )
		{
			using( Log.Block( FDKUtilities.現在のメソッド名 ) )
			{
			}
		}

		public override void 進行描画する( グラフィックデバイス gd )
		{
			Debug.Assert( this.活性化している );
			Debug.Assert( null != gd );

			this._FPS.VPSをカウントする();
			this._FPS.FPSをカウントしプロパティを更新する();

			App.入力管理.すべての入力デバイスをポーリングする();

			switch( this.現在のフェーズ )
			{
				case フェーズ.表示:
					{
						// (1) 描画
						this._背景画像.描画する( gd, 0.0f, 0.0f );
#if DEBUG
						this._FPS.描画する( gd );
#endif
						// (2) 入力
						if( App.入力管理.キーボードデバイス.キーが押された( 0, Key.Escape ) )
						{
							#region " ESC → キャンセル "
							//----------------
							Log.Info( $"{FDKUtilities.現在のメソッド名}: キャンセルされました。" );
							this.現在のフェーズ = フェーズ.キャンセル;
							//----------------
							#endregion
						}
						if( App.入力管理.シンバルが入力された() )
						{
							#region " シンバル → 確定 "
							//----------------
							Log.Info( $"{FDKUtilities.現在のメソッド名}: 確定されました。" );
							this.現在のフェーズ = フェーズ.確定;
							//----------------
							#endregion
						}
					}
					break;

				case フェーズ.確定:
				case フェーズ.キャンセル:
					break;
			}
		}


		private 画像 _背景画像 = null;

		private FPS _FPS = null;
	}
}
