# -*- encoding: utf-8 -*-
#   Copyright 2009 Agile42 GmbH, Berlin (Germany)
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.
#   
#   Author: 
#       - Felix Schwarz <felix.schwarz__at__agile42.com>


from unittest import TestCase

from agilo.test.functional.agilo_tester import SprintBacklogTester

fixture = '''<h1>Sprint Backlog for Agilo 0.8.1 (Hummingbird) - Sprint 1
        <span class="numrows">
                (<span id="items_count">1</span> of <span id="total_items">28</span> items)
        </span>
        </h1>
        <div class="sprint_info">

            <strong><a href="/team/Agilo%20Scrum%20Team">Agilo Scrum Team</a></strong>
            <div class="description"><p>
Goal of the Sprint is to stabilize APIs, improve performance through profiling, and rebuild the Admin interface using new APIs.
</p>'''

class TestSprintBacklogTeamPage(TestCase):
    def test_can_extract_name_of_assigned_team(self):
        tester = SprintBacklogTester(None, 'Foo', html=fixture)
        self.assertEqual('Agilo Scrum Team', tester.team_name())


