#   Copyright 2007 Andrea Tomasini <andrea.tomasini_at_agile42.com>
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

from agilo.ticket.links import LinkOption
from agilo.scrum.charts import ChartType
from agilo.utils import Key, Type
from agilo.utils.config import AgiloConfig
from trac.util.translation import _

# Attention: If you modify the __CONFIG_PROPERTIES__, please copy the old 
# definition to db3 and build an upgrade path (if necessary in db4).
# Felix Schwarz 28.10.2008: It seemed not useful to me just duplicating this 
# long thing in db3.

# List of properties by section that should be created into the trac.ini.
# Values beginning with "+" will be prepended to the existing value as a list
__CONFIG_PROPERTIES__ = {
    'trac': {'permission_policies' : '+AgiloPolicy'},
    'header_logo': {'src': 'agilo/images/default_logo.png'}
}

# This section configure the [components] of agilo in the trac.ini
__CONFIG_PROPERTIES__['components'] = {
    'trac.ticket.api.ticketsystem': 'disabled',
    'trac.ticket.web_ui.ticketmodule': 'disabled',
    'trac.ticket.roadmap.roadmapmodule': 'disabled',
}

# This is the trac.ini [ticket-custom] section
__CONFIG_PROPERTIES__[AgiloConfig.TICKET_CUSTOM] = {
    Key.INCOMING_LINKS: 'text', 
    '%s.label' % Key.INCOMING_LINKS: _('Referenced By'),
    Key.OUTGOING_LINKS: 'text',
    '%s.label' % Key.OUTGOING_LINKS: _('References'),
    Key.REMAINING_TIME: 'text',
    Key.STORY_POINTS: 'select',
    Key.STORY_POINTS + '.label': _('Story Points'),
    Key.STORY_POINTS + '.options': '|0|1|2|3|5|8|13|20|40|100',
    Key.REMAINING_TIME: 'text',
    Key.REMAINING_TIME + '.label': _('Remaining Time'),
    Key.STORY_PRIORITY: 'select',
    Key.STORY_PRIORITY + '.label': _('Importance'),
    Key.STORY_PRIORITY + '.options': '|Mandatory|Linear|Exciter',
    Key.STORY_PRIORITY + '.value': '',
    Key.BUSINESS_VALUE: 'select',
    Key.BUSINESS_VALUE + '.label': _('Business Value'),
    Key.BUSINESS_VALUE + '.options': '|100|200|300|500|800|1200|2000|3000',
    Key.BUSINESS_VALUE + '.value': '',
    Key.SPRINT: 'select',
    Key.SPRINT + '.value': '',
    Key.SPRINT + '.label': _('Sprint'),
    Key.RESOURCES: 'text',
    Key.RESOURCES + '.label': _('Resources'),
    # No options are set for Sprint because it will be dynamically loaded
}
# This is the trac.ini [agilo-links] section
__CONFIG_PROPERTIES__[AgiloConfig.AGILO_LINKS] = {
    'allow': '%(req)s-%(story)s, %(story)s-%(task)s, %(bug)s-%(task)s, %(bug)s-%(story)s' % \
              {'req': Type.REQUIREMENT, 'story': Type.USER_STORY, 'bug': Type.BUG, 'task': Type.TASK},
    '%s.%s.%s' % (Type.REQUIREMENT,
                  Type.USER_STORY,
                  LinkOption.COPY): '%s' % Key.OWNER,
    '%s.%s.%s' % (Type.REQUIREMENT,
                  Type.USER_STORY,
                  LinkOption.SHOW): '%s, %s' % (Key.STORY_POINTS, Key.STORY_PRIORITY),
    '%s.%s' % (Type.REQUIREMENT, LinkOption.CALCULATE): \
                    ('total_story_points=sum:get_outgoing.%s|type=story,' % Key.STORY_POINTS) + \
                    ('mandatory_story_points=sum:get_outgoing.%s|type=story|%s=Mandatory,' % \
                     (Key.STORY_POINTS, Key.STORY_PRIORITY)) + \
                    ('roif=div:%s;%s' % (Key.BUSINESS_VALUE, 'mandatory_story_points')),
    '%s.%s.%s' % (Type.USER_STORY,
                  Type.TASK,
                  LinkOption.COPY): '%s, %s' % (Key.OWNER, Key.SPRINT),
    '%s.%s.%s' % (Type.USER_STORY,
                  Type.TASK,
                  LinkOption.SHOW): '%s, %s' % (Key.OWNER, Key.REMAINING_TIME),
    '%s.%s'    % (Type.USER_STORY, LinkOption.CALCULATE): \
                  ('total_remaining_time=sum:get_outgoing.%s' % Key.REMAINING_TIME) + ',' + \
                  ('estimated_remaining_time=mul:%s;get_sprint.get_team_metrics.%s' % \
                   (Key.STORY_POINTS, Key.RT_USP_RATIO) ),
    '%s.%s.%s' % (Type.BUG, Type.TASK, LinkOption.COPY): '%s, %s' % (Key.OWNER, Key.SPRINT),
    '%s.%s.%s' % (Type.BUG, Type.TASK, LinkOption.SHOW): '%s, %s' % (Key.OWNER, Key.REMAINING_TIME),
    '%s.%s'    % (Type.BUG, LinkOption.CALCULATE): \
                  'total_remaining_time=sum:get_outgoing.%s' % Key.REMAINING_TIME,
    'cache.timeout': '0',
    'cache.related': 'false', # Now disable cache by default, to many problems with 2 CPU
}

# This is the trac.ini [agilo-types] section
__CONFIG_PROPERTIES__[AgiloConfig.AGILO_TYPES] = {
    Type.REQUIREMENT: '%s, %s, %s, %s' % (Key.REPORTER, Key.BUSINESS_VALUE, Key.MILESTONE, Key.KEYWORDS),
    Type.USER_STORY: '%s, %s, %s, %s, %s' % (Key.OWNER, Key.SPRINT, Key.STORY_POINTS, Key.STORY_PRIORITY, Key.KEYWORDS),
    Type.TASK: '%s, %s, %s, %s' % (Key.OWNER, Key.SPRINT, Key.REMAINING_TIME, Key.RESOURCES),
    Type.BUG: '%s, %s, %s' % (Key.OWNER, Key.SPRINT, Key.PRIORITY),
    Type.REQUIREMENT + '.' + Key.ALIAS: _('Requirement'),
    Type.USER_STORY + '.' + Key.ALIAS: _('User Story'),
    Type.TASK + '.' + Key.ALIAS: _('Task'),
    Type.BUG + '.' + Key.ALIAS: _('Bug'),
}

# This is the trac.ini [agilo-backlogs] section
__CONFIG_PROPERTIES__[AgiloConfig.AGILO_BACKLOGS] = {
    'product_backlog.name': _('Product Backlog'),
    'product_backlog.columns': ', '.join(['%s:editable' % Key.BUSINESS_VALUE,
                                          Key.ROIF,
                                          '%s:editable' % Key.STORY_PRIORITY,
                                          '%s:editable|total_story_points' % Key.STORY_POINTS]),
    'sprint_backlog.name': _('Sprint Backlog'),
    'sprint_backlog.columns': ', '.join(['%s:editable|total_remaining_time' % Key.REMAINING_TIME,
                                         '%s:editable' % Key.OWNER, 
                                         '%s:editable' % Key.RESOURCES]),
    'sprint_backlog.charts': ChartType.BURNDOWN
}
