using System;
using System.Collections.Generic;
using System.Text;
using XmlRpcProxy;

namespace TracXmlRpc
{
    public interface ITicket : IService 
    {
        object[] Query();
        object[] Query(string qstr);
        object[] GetRecentChanges(DateTime since);
        object[] GetAvailableActions(int id);
        object[] Get(int id);
        int Create(string summary, string description);
        int Create(string summary, string description, IDictionary<string, object> attributes);
        object[] Update(int id, string comment);
        object[] Update(int id, string comment, IDictionary<string, object> attributes);
        int Delete(int id);
        IDictionary<string, object> ChangeLog(int id);
        IDictionary<string, object> ChangeLog(int id, int when);
        object[] ListAttachments(int ticket);
        byte[] GetAttachment(int ticket, string filename);
        string PutAttachment(int ticket, string filename, string description, byte[] data);
        string PutAttachment(int ticket, string filename, string description, byte[] data, bool replace);
        bool DeleteAttachment(int ticket, string filename);
        object[] GetTicketFields();
    }
}
