﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TracPluginTemplateMaker.CodeGenerator
{
    public class WikiMacroProvider : CodeGeneratorEnvironment, ICodeGenerator
    {
        /// <summary>
        /// インポート部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImportCode()
        {
            return "from trac.wiki.api import IWikiMacroProvider\r\n";
        }

        /// <summary>
        /// 定義部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetDefinationCode()
        {
            return "IWikiMacroProvider";
        }

        /// <summary>
        /// 実装部分のコード
        /// </summary>
        /// <returns></returns>
        public string GetImplementCode()
        {
            return ReadTemplateCode( "IWikiMacroProvider.py.template" );
        }
    }
}
