﻿using System;
using System.Data;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.VisualStudio.Tools.Applications.Runtime;
using Excel=Microsoft.Office.Interop.Excel;
using Office=Microsoft.Office.Core;
using System.Reflection;
using System.Runtime.InteropServices;
using CookComputing.XmlRpc;

namespace TicketImportTemplate
{
    public partial class Sheet2
    {
        private delegate string[] GetAllitem();

        private void Sheet2_Startup( object sender, System.EventArgs e )
        {
            while ( true ) {
                try {
                    Application.SmartTagRecognizers.Recognize = true;

                    LoginInformation li = new LoginInformation();
                    li.StartPosition = FormStartPosition.CenterParent;
                    DialogResult ret = li.ShowDialog( null );
                    if ( ret != DialogResult.OK ) {
                        throw new Exception( "キャンセルされました\n" );
                    }

                    TracProxy.TicketManager trac = new TracProxy.TicketManager();
                    trac.Connect( li.ServerURL + "/login/xmlrpc", li.UserName, li.Password );
                    TracProxy.ITicket ticket = trac.Ticket;
                    object[] obs = ticket.GetTicketFields();

                    Sheet1 sheet1 = Globals.Sheet1;
                    sheet1.Cells.Clear();
                    this.Cells.Clear();

                    for ( int i = 0; i < obs.Length; ++i ) {
                        XmlRpcStruct st = (XmlRpcStruct)obs[i];

                        // 表示名を設定
                        string name = (string)st["name"];
                        sheet1.Cells[1, i + 1] = Cells[1, i + 1] = name;

                        // 表示名の要素を取得
                        GetAllitem getAllItem = null;
                        if ( name == TracProxy.TicketAttributes.Milestone ) {
                            getAllItem = new GetAllitem( ticket.GetAllMilestones );
                        }
                        else if ( name == TracProxy.TicketAttributes.Component ) {
                            getAllItem = new GetAllitem( ticket.GetAllComponents );
                        }
                        else if ( name == TracProxy.TicketAttributes.Priority ) {
                            getAllItem = new GetAllitem( ticket.GetAllPriorities );
                        }
                        else if ( name == TracProxy.TicketAttributes.Resolution ) {
                            getAllItem = new GetAllitem( ticket.GetAllResolutions );
                        }
                        else if ( name == TracProxy.TicketAttributes.Type ) {
                            getAllItem = new GetAllitem( ticket.GetAllTypes );
                        }
                        else if ( name == TracProxy.TicketAttributes.Version ) {
                            getAllItem = new GetAllitem( ticket.GetAllVersions );
                        }
                        else if ( name == TracProxy.TicketAttributes.Status ) {
                            getAllItem = new GetAllitem( ticket.GetAllStatus );
                        }

                        // 入力規則の作成
                        if ( getAllItem != null ) {
                            // セル番号の作成
                            char cell = (char)('A' + i);
                            string dataName = "データ" + i.ToString();

                            string[] items = getAllItem();
                            for ( int j = 0; j < items.Length; ++j ) {
                                Cells[j + 2, i + 1] = items[j];
                            }

                            // シートをまたぐ入力規則用に複数セルに名前をつける
                            {
                                int dataOffset = 2;
                                string start = "$" + cell + "$" + dataOffset.ToString();
                                string end = "$" + cell + "$" + (items.Length + dataOffset).ToString();

                                Controls.AddNamedRange( get_Range( start, end ), dataName );
                            }

                            // コンボボックスの作成
                            {
                                string start = cell + "2";
                                string end = cell + "100";

                                // 別シートの一覧を元に入力規則を作る
                                sheet1.get_Range( start, end ).Validation.Add( Microsoft.Office.Interop.Excel.XlDVType.xlValidateList, Excel.XlDVAlertStyle.xlValidAlertStop,
                                        Excel.XlFormatConditionOperator.xlEqual, "=" + dataName, 0 );
                            }
                        }
                    }

                    break;
                }
                catch ( Exception ex ) {
                    DialogResult ret = MessageBox.Show( "終了しますか？\n\n" + ex.Message, "終了しますか？", MessageBoxButtons.YesNo );
                    if ( ret == DialogResult.Yes ) {
                        Application.Quit();
                        Marshal.ReleaseComObject( Application );
                    }
                }
            }
        }

        private void Sheet2_Shutdown( object sender, System.EventArgs e )
        {
        }


        #region VSTO で生成されたコード

        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InternalStartup()
        {
            this.Startup += new System.EventHandler( Sheet2_Startup );
            this.Shutdown += new System.EventHandler( Sheet2_Shutdown );
        }

        #endregion

    }
}
