﻿using System;
using System.IO;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Configuration;

namespace ExcelTracAddIn
{
    /// <summary>
    /// ログイン情報画面
    /// </summary>
    public partial class LoginInformation : Form
    {
        /// <summary>
        /// 入力されたアカウント情報
        /// </summary>
        public ExcelTracAddInOption.Account Account
        {
            get;
            private set;
        }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public LoginInformation()
        {
            InitializeComponent();

            Account = null;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="Account">初期表示アカウント</param>
        public LoginInformation( ExcelTracAddInOption.Account Account )
            : this()
        {
            serverUrl.Text = Account.Url;
            userName.Text = Account.UserName;
            password.Text = Account.Password;
        }

        private void textBox3_TextChanged( object sender, EventArgs e )
        {
        }

        /// <summary>
        /// OKボタン処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonOK_Click( object sender, EventArgs e )
        {
            Account = new ExcelTracAddInOption.Account( serverUrl.Text,
                                                        userName.Text,
                                                        password.Text );

            Close();
        }

        /// <summary>
        /// キャンセルボタン処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click( object sender, EventArgs e )
        {
            Close();
        }

        // コンボボックスの表示が変更されたので、
        // それにあわせてユーザ名とパスワードを変更する
        public void ComboChangeEvent( object sender, EventArgs e )
        {
        }
    }
}
