﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    /// <summary>
    /// Wiki の添付ファイル
    /// </summary>
    public class WikiAttachment
    {
        /// <summary>
        /// 添付対象の ページ
        /// </summary>
        private Wiki wiki = null;

        /// <summary>
        /// 添付ファイルパス
        /// </summary>
        public string Path
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="wiki">添付対象のページ</param>
        public WikiAttachment( Wiki wiki )
        {
            this.wiki = wiki;
            Path = "";
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="wiki">対象のページ</param>
        /// <param name="path">添付ファイルパス</param>
        public WikiAttachment( Wiki wiki, string path )
        {
            this.wiki = wiki;
            Path = path;
        }

        /// <summary>
        /// 添付ファイルデータの取得
        /// </summary>
        /// <returns>添付ファイルデータ</returns>
        public byte[] Get()
        {
            return Trac.Rpc.wikiGetAttachment( Path );
        }

        /// <summary>
        /// 添付ファイルの追加
        /// </summary>
        /// <param name="path">ファイル名（フルパス）</param>
        /// <param name="description">詳細</param>
        public void Create( string path, string description )
        {
            using ( FileStream fin = new FileStream( path, FileMode.Open ) ) {
                byte[] data = new byte[fin.Length];
                fin.Read( data, 0, data.Length );

                string fileName = Trac.Rpc.wikiPutAttachmentEx( wiki.Name, System.IO.Path.GetFileName( path ), description, data );

                // パスを作成する
                Path = wiki.Name + "/" + fileName;
            }
        }

        /// <summary>
        /// 添付ファイルの更新
        /// </summary>
        /// <param name="data">更新データ</param>
        public void Update( byte[] data )
        {
            bool ret = Trac.Rpc.wikiPutAttachment( Path, data );
            if ( !ret ) {
                throw new Exception( "wikiPutAttachment" );
            }
        }

        /// <summary>
        /// 添付ファイルを削除する
        /// </summary>
        public void Delete()
        {
            Delete( Path );
        }

        /// <summary>
        /// 指定された添付ファイルを削除する
        /// </summary>
        /// <param name="path">削除する添付ファイルのパス</param>
        public static void Delete( string path )
        {
            bool ret = Trac.Rpc.wikiDeleteAttachment( path );
            if ( !ret ) {
                throw new Exception( "wikiDeleteAttachment" );
            }
        }
    }
}
