﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BTS.Trac
{
    /// <summary>
    /// チケットのチェンジログ
    /// </summary>
    public class TicketChangeLog
    {
        /// <summary>
        /// 変更日時
        /// </summary>
        public DateTime Modified
        {
            get;
            private set;
        }

        /// <summary>
        /// 更新者
        /// </summary>
        public string Updater
        {
            get;
            private set;
        }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// 変更前
        /// </summary>
        public string Before
        {
            get;
            private set;
        }

        /// <summary>
        /// 変更後
        /// </summary>
        public string After
        {
            get;
            private set;
        }

        /// <summary>
        /// わからん int 値
        /// </summary>
        public int Unknown
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="log"></param>
        public TicketChangeLog( object[] log )
        {
            Modified = (DateTime)log[0];
            Updater = (string)log[1];
            Name = (string)log[2];
            Before = (string)log[3];
            After = (string)log[4];
            Unknown = (int)log[5];
        }
    }
}
