﻿using System;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    // 使うときはこうやって使ってください
    using Status = TracNameAndValueField<IStatus>;

    /// <summary>
    /// 状態
    /// </summary>
    /// <note>
    /// create のアクセス方法がわからないので、GetAll のみ使用すること
    /// </note>
    public interface IStatus : ITracNameAndValueField
    {
        /// <summary>
        /// 状態の一覧を取得する
        /// </summary>
        /// <returns>状態の一覧</returns>
        [XmlRpcMethod( "ticket.status.getAll" )]
        new string[] GetAll();

        /// <summary>
        /// 状態の詳細を取得する
        /// </summary>
        /// <param name="name">取得する状態の名称</param>
        /// <returns>状態の名称（引数と同じ？）</returns>
        [XmlRpcMethod( "ticket.status.get" )]
        new string Get( string name );

        /// <summary>
        /// 
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        /// <note>
        /// 使用しないこと
        /// </note>
        [XmlRpcMethod( "ticket.status.delete" )]
        new int Delete( string name );

        /// <summary>
        /// 
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        /// <note>
        /// 使用しないこと
        /// </note>
        [XmlRpcMethod( "ticket.status.create" )]
        new int Create( string name, string value );

        /// <summary>
        /// 
        /// </summary>
        /// <param name="name"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        /// <note>
        /// 使用しないこと
        /// </note>
        [XmlRpcMethod( "ticket.status.update" )]
        new int Update( string name, string value );
    }
}
