﻿using System;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    // 使うときはこうやって使ってください
    using Priority = TracNameAndValueField<IPriority>;

    /// <summary>
    /// 優先度
    /// </summary>
    public interface IPriority : ITracNameAndValueField
    {
        /// <summary>
        /// すべての優先度を取得
        /// </summary>
        /// <returns>優先度の一覧</returns>
        [XmlRpcMethod( "ticket.priority.getAll" )]
        new string[] GetAll();

        /// <summary>
        /// 優先度の詳細を取得
        /// </summary>
        /// <param name="name">取得する優先度の名称</param>
        /// <returns>順序</returns>
        [XmlRpcMethod( "ticket.priority.get" )]
        new string Get( string name );

        /// <summary>
        /// 指定された優先度を削除する
        /// </summary>
        /// <param name="name">削除する優先度の名称</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.priority.delete" )]
        new int Delete( string name );

        /// <summary>
        /// 新しい優先度を作成する
        /// </summary>
        /// <param name="name">作成する優先度</param>
        /// <param name="value">作成する優先度の順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.priority.create" )]
        new int Create( string name, string value );

        /// <summary>
        /// 指定された優先度を更新する
        /// </summary>
        /// <param name="name">更新する優先度の名称</param>
        /// <param name="value">更新する順序</param>
        /// <returns>処理結果</returns>
        [XmlRpcMethod( "ticket.priority.update" )]
        new int Update( string name, string value );
    }
}
