﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using Meyn.TestLink;

namespace BTS.Trac.Test
{
    [TestFixture]
    [TestLinkFixture(
        Url = TestLinkConnect.Url,
        ProjectName = TestLinkConnect.ProjectName,
        UserId = TestLinkConnect.UserId,
        TestPlan = TestLinkConnect.TestPlan,
        TestSuite = TestLinkConnect.TestSuite,
        DevKey = TestLinkConnect.DevKey )]
    public class XmlRpcSystemTest
    {
        [SetUp]
        public void SetUp()
        {
            Trac.Connect( TracConnect.Url, TracConnect.UserName, TracConnect.Password );
        }

        [TearDown]
        public void TearDown()
        {
            Trac.Close();
        }

        [Test]
        public void APIバージョンを取得する()
        {
            string version = TracXmlRpcSystem.GetAPIVersion();
            Assert.AreEqual( version, "1.0.0" );
        }

        [Test]
        public void メソッドに関するAPIのテスト()
        {
            string[] methods = TracXmlRpcSystem.ListMethods();
            Assert.AreNotEqual( methods.Length, 0 );

            string[] methodSignatures = TracXmlRpcSystem.GetMethodSignature( methods[0] );
            Assert.AreNotEqual( methodSignatures.Length, 0 );
        }
    }
}
