/**
 * 
 */
package jp.mydns.masahase.abaqus;

import java.io.EOFException;
import java.io.FileNotFoundException;

/**
 * 結果ファイル読み込みのためのインターフェイス
 * 
 * @author MASA.H
 * @version 1.0
 */
public interface IReadFil {
	/**
	 * 読み取るファイル名の指定
	 * 
	 * @param fname
	 *            ファイル名
	 * @throws FileNotFoundException
	 */
	void setFileName(String fname) throws FileNotFoundException;

	/**
	 * 次のレコードキーの取得し、現在位置を次のレコードに進める
	 * 
	 * @return レコードキー
	 * @throws EOFException
	 */
	int getNextRecordKey() throws EOFException;

	/**
	 * レコードの内容を取得
	 * 
	 * @return レコードの内容が入った配列
	 */
	Object[] getRecordContents();

	/**
	 * 現在位置を先頭レコードに戻す
	 */
	void rewind();

	/**
	 * 対応しているファイルかどうか
	 * 
	 * @return 対応しているかどうかのブーリアン
	 */
	boolean isType();
}
