/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.DigestMD5;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import com.sun.mail.util.TraceInputStream;
import com.sun.mail.util.TraceOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

public class SMTPTransport
extends Transport {
    private String name = "smtp";
    private int defaultPort = 25;
    private boolean isSSL = false;
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    boolean sendPartiallyFailed = false;
    MessagingException exception;
    private Hashtable extMap;
    private boolean noAuth = false;
    private boolean quitWait = false;
    private String saslRealm = "UNKNOWN";
    private boolean reportSuccess;
    private boolean useStartTLS;
    private PrintStream out;
    private String localHostName;
    private String lastServerResponse;
    private int lastReturnCode;
    private static final String[] ignoreList = new String[]{"Bcc", "Content-Length"};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String UNKNOWN = "UNKNOWN";
    private DigestMD5 md5support;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private Socket serverSocket;
    private static char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SMTPTransport(Session session, URLName uRLName) {
        this(session, uRLName, "smtp", 25, false);
    }

    protected SMTPTransport(Session session, URLName uRLName, String string, int n, boolean bl) {
        super(session, uRLName);
        if (uRLName != null) {
            string = uRLName.getProtocol();
        }
        this.name = string;
        this.defaultPort = n;
        this.isSSL = bl;
        this.out = session.getDebugOut();
        String string2 = session.getProperty("mail." + string + ".quitwait");
        this.quitWait = string2 != null && string2.equalsIgnoreCase("true");
        string2 = session.getProperty("mail." + string + ".reportsuccess");
        this.reportSuccess = string2 != null && string2.equalsIgnoreCase("true");
        string2 = session.getProperty("mail." + string + ".starttls.enable");
        this.useStartTLS = string2 != null && string2.equalsIgnoreCase("true");
    }

    public String getLocalHost() {
        try {
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = this.session.getProperty("mail." + this.name + ".localhost");
            }
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = this.session.getProperty("mail." + this.name + ".localaddress");
            }
            if (this.localHostName == null || this.localHostName.length() <= 0) {
                this.localHostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.localHostName;
    }

    public void setLocalHost(String string) {
        this.localHostName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect() throws MessagingException {
        try {
            this.noAuth = true;
            super.connect();
        }
        finally {
            this.noAuth = false;
        }
    }

    public String getSASLRealm() {
        if (this.saslRealm == UNKNOWN) {
            this.saslRealm = this.session.getProperty("mail." + this.name + ".sasl.realm");
            if (this.saslRealm == null) {
                this.saslRealm = this.session.getProperty("mail." + this.name + ".saslrealm");
            }
        }
        return this.saslRealm;
    }

    public void setSASLRealm(String string) {
        this.saslRealm = string;
    }

    public boolean getReportSuccess() {
        return this.reportSuccess;
    }

    public void setReportSuccess(boolean bl) {
        this.reportSuccess = bl;
    }

    public boolean getStartTLS() {
        return this.useStartTLS;
    }

    public void setStartTLS(boolean bl) {
        this.useStartTLS = bl;
    }

    public String getLastServerResponse() {
        return this.lastServerResponse;
    }

    private synchronized DigestMD5 getMD5() {
        if (this.md5support == null) {
            this.md5support = new DigestMD5(this.debug ? this.out : null);
        }
        return this.md5support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        DigestMD5 digestMD5;
        boolean bl;
        String string4 = this.session.getProperty("mail." + this.name + ".ehlo");
        boolean bl2 = string4 == null || !string4.equalsIgnoreCase("false");
        String string5 = this.session.getProperty("mail." + this.name + ".auth");
        boolean bl3 = bl = string5 != null && string5.equalsIgnoreCase("true");
        if (this.debug) {
            this.out.println("DEBUG SMTP: useEhlo " + bl2 + ", useAuth " + bl);
        }
        if (bl && (string2 == null || string3 == null)) {
            return false;
        }
        if (n == -1) {
            String string6 = this.session.getProperty("mail." + this.name + ".port");
            n = string6 != null ? Integer.parseInt(string6) : this.defaultPort;
        }
        if (string == null || string.length() == 0) {
            string = "localhost";
        }
        boolean bl4 = false;
        this.openServer(string, n);
        if (bl2) {
            bl4 = this.ehlo(this.getLocalHost());
        }
        if (!bl4) {
            this.helo(this.getLocalHost());
        }
        if (this.useStartTLS && this.supportsExtension("STARTTLS")) {
            this.startTLS();
            this.ehlo(this.getLocalHost());
        }
        if (!bl || !this.supportsExtension("AUTH") && !this.supportsExtension("AUTH=LOGIN")) return true;
        if (this.debug) {
            this.out.println("DEBUG SMTP: Attempt to authenticate");
            if (!this.supportsAuthentication("LOGIN") && this.supportsExtension("AUTH=LOGIN")) {
                this.out.println("DEBUG SMTP: use AUTH=LOGIN hack");
            }
        }
        if (this.supportsAuthentication("LOGIN") || this.supportsExtension("AUTH=LOGIN")) {
            int n2 = this.simpleCommand("AUTH LOGIN");
            if (n2 == 530) {
                this.startTLS();
                n2 = this.simpleCommand("AUTH LOGIN");
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
                if (n2 == 334) {
                    ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string2));
                    ((OutputStream)bASE64EncoderStream).flush();
                    n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.reset();
                }
                if (n2 != 334) return true;
                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string3));
                ((OutputStream)bASE64EncoderStream).flush();
                n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.reset();
                return true;
            }
            catch (IOException iOException) {
                if (n2 == 235) return true;
                this.closeConnection();
                return false;
            }
            finally {
                if (n2 != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (this.supportsAuthentication("PLAIN")) {
            int n3 = this.simpleCommand("AUTH PLAIN");
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
                if (n3 != 334) return true;
                ((OutputStream)bASE64EncoderStream).write(0);
                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string2));
                ((OutputStream)bASE64EncoderStream).write(0);
                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string3));
                ((OutputStream)bASE64EncoderStream).flush();
                n3 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                return true;
            }
            catch (IOException iOException) {
                if (n3 == 235) return true;
                this.closeConnection();
                return false;
            }
            finally {
                if (n3 != 235) {
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (!this.supportsAuthentication("DIGEST-MD5") || (digestMD5 = this.getMD5()) == null) return true;
        int n4 = this.simpleCommand("AUTH DIGEST-MD5");
        try {
            byte[] byArray;
            if (n4 != 334 || (n4 = this.simpleCommand(byArray = digestMD5.authClient(string, string2, string3, this.getSASLRealm(), this.lastServerResponse))) != 334) return true;
            n4 = !digestMD5.authServer(this.lastServerResponse) ? -1 : this.simpleCommand(new byte[0]);
            return true;
        }
        catch (Exception exception) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: DIGEST-MD5: " + exception);
            }
        }
        finally {
            if (n4 == 235) return true;
            this.closeConnection();
            return false;
        }
    }

    public synchronized void sendMessage(Message message, Address[] addressArray) throws MessagingException, SendFailedException {
        boolean bl;
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        for (bl = false; bl < addressArray.length; bl += 1) {
            if (addressArray[bl] instanceof InternetAddress) continue;
            throw new MessagingException(addressArray[bl] + " is not an InternetAddress");
        }
        this.message = (MimeMessage)message;
        this.addresses = addressArray;
        this.validUnsentAddr = addressArray;
        this.expandGroups();
        bl = false;
        if (message instanceof SMTPMessage) {
            bl = ((SMTPMessage)message).getAllow8bitMIME();
        }
        if (!bl) {
            String string = this.session.getProperty("mail." + this.name + ".allow8bitmime");
            boolean bl2 = bl = string != null && string.equalsIgnoreCase("true");
        }
        if (this.debug) {
            this.out.println("DEBUG SMTP: use8bit " + bl);
        }
        if (bl && this.supportsExtension("8BITMIME")) {
            this.convertTo8Bit(this.message);
        }
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                if (this.sendPartiallyFailed) {
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Sending partially failed because of invalid destination addresses");
                    }
                    this.notifyTransportListeners(3, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                    throw new SMTPSendFailedException(".", this.lastReturnCode, this.lastServerResponse, this.exception, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
                }
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            }
            catch (MessagingException messagingException) {
                if (this.debug) {
                    messagingException.printStackTrace(this.out);
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw messagingException;
            }
            catch (IOException iOException) {
                if (this.debug) {
                    iOException.printStackTrace(this.out);
                }
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException) {
                    // empty catch block
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw new MessagingException("IOException while sending message", iOException);
            }
            Object var7_7 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws MessagingException {
        if (!super.isConnected()) {
            return;
        }
        try {
            if (this.serverSocket != null) {
                int n;
                this.sendCommand("QUIT");
                if (this.quitWait && (n = this.readServerResponse()) != 221 && n != -1) {
                    this.out.println("DEBUG SMTP: QUIT failed with " + n);
                }
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection() throws MessagingException {
        try {
            block4: {
                try {
                    if (this.serverSocket == null) break block4;
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    throw new MessagingException("Server Close Failed", iOException);
                }
            }
            Object var3_1 = null;
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (!super.isConnected()) return;
            super.close();
            return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
            if (!super.isConnected()) throw throwable;
            super.close();
            throw throwable;
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int n = this.readServerResponse();
            if (n >= 0 && n != 421) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
        catch (Exception exception) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {
                // empty catch block
            }
            return false;
        }
    }

    private void expandGroups() {
        Vector<InternetAddress> vector = null;
        for (int i = 0; i < this.addresses.length; ++i) {
            InternetAddress internetAddress = (InternetAddress)this.addresses[i];
            if (internetAddress.isGroup()) {
                if (vector == null) {
                    vector = new Vector<InternetAddress>();
                    for (int j = 0; j < i; ++j) {
                        vector.addElement((InternetAddress)this.addresses[j]);
                    }
                }
                try {
                    InternetAddress[] internetAddressArray = internetAddress.getGroup(true);
                    if (internetAddressArray != null) {
                        for (int j = 0; j < internetAddressArray.length; ++j) {
                            vector.addElement(internetAddressArray[j]);
                        }
                        continue;
                    }
                    vector.addElement(internetAddress);
                }
                catch (ParseException parseException) {
                    vector.addElement(internetAddress);
                }
                continue;
            }
            if (vector == null) continue;
            vector.addElement(internetAddress);
        }
        if (vector != null) {
            Object[] objectArray = new InternetAddress[vector.size()];
            vector.copyInto(objectArray);
            this.addresses = objectArray;
        }
    }

    private void convertTo8Bit(MimePart mimePart) {
        try {
            if (mimePart.isMimeType("text/*")) {
                InputStream inputStream;
                String string = mimePart.getEncoding();
                if ((string.equalsIgnoreCase("quoted-printable") || string.equalsIgnoreCase("base64")) && this.is8Bit(inputStream = mimePart.getInputStream())) {
                    mimePart.setHeader("Content-Transfer-Encoding", "8bit");
                }
            } else if (mimePart.isMimeType("multipart/*")) {
                MimeMultipart mimeMultipart = (MimeMultipart)mimePart.getContent();
                int n = mimeMultipart.getCount();
                for (int i = 0; i < n; ++i) {
                    this.convertTo8Bit((MimePart)((Object)mimeMultipart.getBodyPart(i)));
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private boolean is8Bit(InputStream inputStream) {
        int n = 0;
        boolean bl = false;
        try {
            int n2;
            while ((n2 = inputStream.read()) >= 0) {
                if ((n2 &= 0xFF) == 13 || n2 == 10) {
                    n = 0;
                } else {
                    if (n2 == 0) {
                        return false;
                    }
                    if (++n > 998) {
                        return false;
                    }
                }
                if (n2 <= 127) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.debug && bl) {
            this.out.println("DEBUG SMTP: found an 8bit part");
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void helo(String string) throws MessagingException {
        if (string != null) {
            this.issueCommand("HELO " + string, 250);
        } else {
            this.issueCommand("HELO", 250);
        }
    }

    private boolean ehlo(String string) throws MessagingException {
        String string2 = string != null ? "EHLO " + string : "EHLO";
        this.sendCommand(string2);
        int n = this.readServerResponse();
        if (n == 250) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String string3;
                boolean bl = true;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    if (string3.length() < 5) continue;
                    string3 = string3.substring(4);
                    int n2 = string3.indexOf(32);
                    String string4 = "";
                    if (n2 > 0) {
                        string4 = string3.substring(n2 + 1);
                        string3 = string3.substring(0, n2);
                    }
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: Found extension \"" + string3 + "\", arg \"" + string4 + "\"");
                    }
                    this.extMap.put(string3.toUpperCase(), string4);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n == 250;
    }

    private void mailFrom() throws MessagingException {
        Object object;
        Object object2;
        block18: {
            String string = null;
            if (this.message instanceof SMTPMessage) {
                string = ((SMTPMessage)this.message).getEnvelopeFrom();
            }
            if (string == null || string.length() <= 0) {
                string = this.session.getProperty("mail." + this.name + ".from");
            }
            if (string == null || string.length() <= 0) {
                object = this.message != null && (object2 = this.message.getFrom()) != null && ((Address[])object2).length > 0 ? object2[0] : InternetAddress.getLocalAddress(this.session);
                if (object != null) {
                    string = ((InternetAddress)object).getAddress();
                } else {
                    throw new MessagingException("can't determine local email address");
                }
            }
            object2 = "MAIL FROM:" + this.normalizeAddress(string);
            if (this.supportsExtension("DSN")) {
                object = null;
                if (this.message instanceof SMTPMessage) {
                    object = ((SMTPMessage)this.message).getDSNRet();
                }
                if (object == null) {
                    object = this.session.getProperty("mail." + this.name + ".dsn.ret");
                }
                if (object != null) {
                    object2 = (String)object2 + " RET=" + (String)object;
                }
            }
            if (this.supportsExtension("AUTH")) {
                object = null;
                if (this.message instanceof SMTPMessage) {
                    object = ((SMTPMessage)this.message).getSubmitter();
                }
                if (object == null) {
                    object = this.session.getProperty("mail." + this.name + ".submitter");
                }
                if (object != null) {
                    try {
                        String string2 = this.xtext((String)object);
                        object2 = (String)object2 + " AUTH=" + string2;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (!this.debug) break block18;
                        this.out.println("DEBUG SMTP: ignoring invalid submitter: " + (String)object + ", Exception: " + illegalArgumentException);
                    }
                }
            }
        }
        object = null;
        if (this.message instanceof SMTPMessage) {
            object = ((SMTPMessage)this.message).getMailExtension();
        }
        if (object == null) {
            object = this.session.getProperty("mail." + this.name + ".mailextension");
        }
        if (object != null && ((String)object).length() > 0) {
            object2 = (String)object2 + " " + (String)object;
        }
        this.issueSendCommand((String)object2, 250);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rcptTo() throws MessagingException {
        int n;
        Vector<InternetAddress> vector = new Vector<InternetAddress>();
        Vector<InternetAddress> vector2 = new Vector<InternetAddress>();
        Vector<InternetAddress> vector3 = new Vector<InternetAddress>();
        int n2 = -1;
        MessagingException messagingException = null;
        boolean bl = false;
        MessagingException messagingException2 = null;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean bl2 = false;
        if (this.message instanceof SMTPMessage) {
            bl2 = ((SMTPMessage)this.message).getSendPartial();
        }
        if (!bl2) {
            String string = this.session.getProperty("mail." + this.name + ".sendpartial");
            bl2 = string != null && string.equalsIgnoreCase("true");
        }
        boolean bl3 = false;
        String string = null;
        if (this.supportsExtension("DSN")) {
            if (this.message instanceof SMTPMessage) {
                string = ((SMTPMessage)this.message).getDSNNotify();
            }
            if (string == null) {
                string = this.session.getProperty("mail." + this.name + ".dsn.notify");
            }
            if (string != null) {
                bl3 = true;
            }
        }
        block12: for (n = 0; n < this.addresses.length; ++n) {
            messagingException2 = null;
            InternetAddress internetAddress = (InternetAddress)this.addresses[n];
            String string2 = "RCPT TO:" + this.normalizeAddress(internetAddress.getAddress());
            if (bl3) {
                string2 = string2 + " NOTIFY=" + string;
            }
            this.sendCommand(string2);
            n2 = this.readServerResponse();
            switch (n2) {
                case 250: 
                case 251: {
                    vector.addElement(internetAddress);
                    if (!this.reportSuccess) continue block12;
                    messagingException2 = new SMTPAddressSucceededException(internetAddress, string2, n2, this.lastServerResponse);
                    if (messagingException == null) {
                        messagingException = messagingException2;
                        continue block12;
                    }
                    messagingException.setNextException(messagingException2);
                    continue block12;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    if (!bl2) {
                        bl = true;
                    }
                    vector3.addElement(internetAddress);
                    messagingException2 = new SMTPAddressFailedException(internetAddress, string2, n2, this.lastServerResponse);
                    if (messagingException == null) {
                        messagingException = messagingException2;
                        continue block12;
                    }
                    messagingException.setNextException(messagingException2);
                    continue block12;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    if (!bl2) {
                        bl = true;
                    }
                    vector2.addElement(internetAddress);
                    messagingException2 = new SMTPAddressFailedException(internetAddress, string2, n2, this.lastServerResponse);
                    if (messagingException == null) {
                        messagingException = messagingException2;
                        continue block12;
                    }
                    messagingException.setNextException(messagingException2);
                    continue block12;
                }
                default: {
                    if (n2 >= 400 && n2 <= 499) {
                        vector2.addElement(internetAddress);
                    } else if (n2 >= 500 && n2 <= 599) {
                        vector3.addElement(internetAddress);
                    } else {
                        if (this.debug) {
                            this.out.println("DEBUG SMTP: got response code " + n2 + ", with response: " + this.lastServerResponse);
                        }
                        String string3 = this.lastServerResponse;
                        int n3 = this.lastReturnCode;
                        if (this.serverSocket != null) {
                            this.issueCommand("RSET", 250);
                        }
                        this.lastServerResponse = string3;
                        this.lastReturnCode = n3;
                        throw new SMTPAddressFailedException(internetAddress, string2, n2, string3);
                    }
                    if (!bl2) {
                        bl = true;
                    }
                    messagingException2 = new SMTPAddressFailedException(internetAddress, string2, n2, this.lastServerResponse);
                    if (messagingException == null) {
                        messagingException = messagingException2;
                        continue block12;
                    }
                    messagingException.setNextException(messagingException2);
                }
            }
        }
        if (bl2 && vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            int n4;
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector.size() + vector2.size()];
            n = 0;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                this.validUnsentAddr[n++] = (Address)vector.elementAt(n4);
            }
            for (n4 = 0; n4 < vector2.size(); ++n4) {
                this.validUnsentAddr[n++] = (Address)vector2.elementAt(n4);
            }
        } else if (this.reportSuccess || bl2 && (vector3.size() > 0 || vector2.size() > 0)) {
            this.sendPartiallyFailed = true;
            this.exception = messagingException;
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector2.size()];
            vector2.copyInto(this.validUnsentAddr);
            this.validSentAddr = new Address[vector.size()];
            vector.copyInto(this.validSentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Verified Addresses");
                for (n = 0; n < this.validSentAddr.length; ++n) {
                    this.out.println("DEBUG SMTP:   " + this.validSentAddr[n]);
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                this.out.println("DEBUG SMTP: Valid Unsent Addresses");
                for (n = 0; n < this.validUnsentAddr.length; ++n) {
                    this.out.println("DEBUG SMTP:   " + this.validUnsentAddr[n]);
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                this.out.println("DEBUG SMTP: Invalid Addresses");
                for (n = 0; n < this.invalidAddr.length; ++n) {
                    this.out.println("DEBUG SMTP:   " + this.invalidAddr[n]);
                }
            }
        }
        if (bl) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: Sending failed because of invalid destination addresses");
            }
            this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            String string4 = this.lastServerResponse;
            int n5 = this.lastReturnCode;
            try {
                if (this.serverSocket != null) {
                    this.issueCommand("RSET", 250);
                }
            }
            catch (MessagingException messagingException3) {
                try {
                    this.close();
                }
                catch (MessagingException messagingException4) {
                    if (this.debug) {
                        messagingException4.printStackTrace(this.out);
                    }
                }
            }
            finally {
                this.lastServerResponse = string4;
                this.lastReturnCode = n5;
            }
            throw new SendFailedException("Invalid Addresses", messagingException, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueSendCommand("DATA", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueSendCommand("\r\n.", 250);
    }

    private void startTLS() throws MessagingException {
        this.issueCommand("STARTTLS", 220);
        try {
            this.serverSocket = SocketFetcher.startTLS(this.serverSocket);
            this.initStreams();
        }
        catch (IOException iOException) {
            this.closeConnection();
            throw new MessagingException("Could not convert socket to TLS", iOException);
        }
    }

    private void openServer(String string, int n) throws MessagingException {
        if (this.debug) {
            this.out.println("DEBUG SMTP: trying to connect to host \"" + string + "\", port " + n + ", isSSL " + this.isSSL);
        }
        try {
            Properties properties = this.session.getProperties();
            this.serverSocket = SocketFetcher.getSocket(string, n, properties, "mail." + this.name, this.isSSL);
            n = this.serverSocket.getPort();
            this.initStreams();
            int n2 = -1;
            n2 = this.readServerResponse();
            if (n2 != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.debug) {
                    this.out.println("DEBUG SMTP: could not connect to host \"" + string + "\", port: " + n + ", response: " + n2 + "\n");
                }
                throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n + ", response: " + n2);
            }
            if (this.debug) {
                this.out.println("DEBUG SMTP: connected to host \"" + string + "\", port: " + n + "\n");
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new MessagingException("Unknown SMTP host: " + string, unknownHostException);
        }
        catch (IOException iOException) {
            throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n, iOException);
        }
    }

    private void initStreams() throws IOException {
        Properties properties = this.session.getProperties();
        PrintStream printStream = this.session.getDebugOut();
        boolean bl = this.session.getDebug();
        String string = properties.getProperty("mail.debug.quote");
        boolean bl2 = string != null && string.equalsIgnoreCase("true");
        TraceInputStream traceInputStream = new TraceInputStream(this.serverSocket.getInputStream(), printStream);
        traceInputStream.setTrace(bl);
        traceInputStream.setQuote(bl2);
        TraceOutputStream traceOutputStream = new TraceOutputStream(this.serverSocket.getOutputStream(), printStream);
        traceOutputStream.setTrace(bl);
        traceOutputStream.setQuote(bl2);
        this.serverOutput = new BufferedOutputStream(traceOutputStream);
        this.serverInput = new BufferedInputStream(traceInputStream);
        this.lineInputStream = new LineInputStream(this.serverInput);
    }

    private void issueCommand(String string, int n) throws MessagingException {
        this.sendCommand(string);
        if (this.readServerResponse() != n) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private void issueSendCommand(String string, int n) throws MessagingException {
        this.sendCommand(string);
        int n2 = this.readServerResponse();
        if (n2 != n) {
            int n3 = this.validSentAddr == null ? 0 : this.validSentAddr.length;
            int n4 = this.validUnsentAddr == null ? 0 : this.validUnsentAddr.length;
            Address[] addressArray = new Address[n3 + n4];
            if (n3 > 0) {
                System.arraycopy(this.validSentAddr, 0, addressArray, 0, n3);
            }
            if (n4 > 0) {
                System.arraycopy(this.validUnsentAddr, 0, addressArray, n3, n4);
            }
            this.validSentAddr = null;
            this.validUnsentAddr = addressArray;
            throw new SMTPSendFailedException(string, n2, this.lastServerResponse, this.exception, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private int simpleCommand(String string) throws MessagingException {
        this.sendCommand(string);
        return this.readServerResponse();
    }

    private int simpleCommand(byte[] byArray) throws MessagingException {
        this.sendCommand(byArray);
        return this.readServerResponse();
    }

    private void sendCommand(String string) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes(string));
    }

    private void sendCommand(byte[] byArray) throws MessagingException {
        try {
            this.serverOutput.write(byArray);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
        }
        catch (IOException iOException) {
            throw new MessagingException("Can't send command to SMTP host", iOException);
        }
    }

    private int readServerResponse() throws MessagingException {
        String string = "";
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string2 = null;
            do {
                if ((string2 = this.lineInputStream.readLine()) == null) {
                    string = stringBuffer.toString();
                    if (string.length() == 0) {
                        string = "[EOF]";
                    }
                    this.lastServerResponse = string;
                    this.lastReturnCode = -1;
                    if (this.debug) {
                        this.out.println("DEBUG SMTP: EOF: " + string);
                    }
                    return -1;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            } while (this.isNotLastLine(string2));
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            if (this.debug) {
                this.out.println("DEBUG SMTP: exception reading response: " + iOException);
            }
            this.lastServerResponse = "";
            this.lastReturnCode = 0;
            throw new MessagingException("Exception reading response", iOException);
        }
        if (string != null && string.length() >= 3) {
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                block17: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block17;
                        messagingException.printStackTrace(this.out);
                    }
                }
                n = -1;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                block18: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block18;
                        messagingException.printStackTrace(this.out);
                    }
                }
                n = -1;
            }
        } else {
            n = -1;
        }
        if (n == -1 && this.debug) {
            this.out.println("DEBUG SMTP: bad server response: " + string);
        }
        this.lastServerResponse = string;
        this.lastReturnCode = n;
        return n;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String string) {
        return string != null && string.length() >= 4 && string.charAt(3) == '-';
    }

    private String normalizeAddress(String string) {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            return "<" + string + ">";
        }
        return string;
    }

    public boolean supportsExtension(String string) {
        return this.extMap != null && this.extMap.get(string.toUpperCase()) != null;
    }

    public String getExtensionParameter(String string) {
        return this.extMap == null ? null : (String)this.extMap.get(string.toUpperCase());
    }

    private boolean supportsAuthentication(String string) {
        if (this.extMap == null) {
            return false;
        }
        String string2 = (String)this.extMap.get("AUTH");
        if (string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private String xtext(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\u0080') {
                throw new IllegalArgumentException("Non-ASCII character in SMTP submitter: " + string);
            }
            if (c < '!' || c > '~' || c == '+' || c == '=') {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() + 4);
                    stringBuffer.append(string.substring(0, i));
                }
                stringBuffer.append('+');
                stringBuffer.append(hexchar[(c & 0xF0) >> 4]);
                stringBuffer.append(hexchar[c & 0xF]);
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer != null ? stringBuffer.toString() : string;
    }
}

