/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.DOM;
import com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMAxisIteratorBase;

public final class UnionIterator
extends DTMAxisIteratorBase {
    private final DOM _dom;
    private static final int InitSize = 8;
    private int _heapSize = 0;
    private int _size = 8;
    private LookAheadIterator[] _heap = new LookAheadIterator[8];
    private int _free = 0;
    private int _returnedLast;
    private int _cachedReturnedLast = -1;
    private int _cachedHeapSize;

    public UnionIterator(DOM dom) {
        this._dom = dom;
    }

    public DTMAxisIterator cloneIterator() {
        this._isRestartable = false;
        LookAheadIterator[] heapCopy = new LookAheadIterator[this._heap.length];
        try {
            UnionIterator clone = (UnionIterator)super.clone();
            for (int i = 0; i < this._free; ++i) {
                heapCopy[i] = this._heap[i].cloneIterator();
            }
            clone.setRestartable(false);
            clone._heap = heapCopy;
            return clone.reset();
        }
        catch (CloneNotSupportedException e) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", e.toString());
            return null;
        }
    }

    public UnionIterator addIterator(DTMAxisIterator iterator) {
        if (this._free == this._size) {
            LookAheadIterator[] newArray = new LookAheadIterator[this._size *= 2];
            System.arraycopy(this._heap, 0, newArray, 0, this._free);
            this._heap = newArray;
        }
        ++this._heapSize;
        this._heap[this._free++] = new LookAheadIterator(iterator);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() {
        while (this._heapSize > 0) {
            int smallest = this._heap[0].node;
            if (smallest == -1) {
                if (this._heapSize <= 1) return -1;
                LookAheadIterator temp = this._heap[0];
                this._heap[0] = this._heap[--this._heapSize];
                this._heap[this._heapSize] = temp;
            } else if (smallest == this._returnedLast) {
                this._heap[0].step();
            } else {
                this._heap[0].step();
                this.heapify(0);
                this._returnedLast = smallest;
                return this.returnNode(this._returnedLast);
            }
            this.heapify(0);
        }
        return -1;
    }

    public DTMAxisIterator setStartNode(int node) {
        if (this._isRestartable) {
            int i;
            this._startNode = node;
            for (i = 0; i < this._free; ++i) {
                if (this._heap[i].isStartSet) continue;
                this._heap[i].iterator.setStartNode(node);
                this._heap[i].step();
                this._heap[i].isStartSet = true;
            }
            this._heapSize = this._free;
            for (i = this._heapSize / 2; i >= 0; --i) {
                this.heapify(i);
            }
            this._returnedLast = -1;
            return this.resetPosition();
        }
        return this;
    }

    private void heapify(int i) {
        while (true) {
            int r;
            int l;
            int smallest;
            int n = smallest = (l = (r = i + 1 << 1) - 1) < this._heapSize && this._dom.lessThan(this._heap[l].node, this._heap[i].node) ? l : i;
            if (r < this._heapSize && this._dom.lessThan(this._heap[r].node, this._heap[smallest].node)) {
                smallest = r;
            }
            if (smallest == i) break;
            LookAheadIterator temp = this._heap[smallest];
            this._heap[smallest] = this._heap[i];
            this._heap[i] = temp;
            i = smallest;
        }
    }

    public void setMark() {
        for (int i = 0; i < this._free; ++i) {
            this._heap[i].setMark();
        }
        this._cachedReturnedLast = this._returnedLast;
        this._cachedHeapSize = this._heapSize;
    }

    public void gotoMark() {
        int i;
        for (i = 0; i < this._free; ++i) {
            this._heap[i].gotoMark();
        }
        this._heapSize = this._cachedHeapSize;
        for (i = this._heapSize / 2; i >= 0; --i) {
            this.heapify(i);
        }
        this._returnedLast = this._cachedReturnedLast;
    }

    public DTMAxisIterator reset() {
        int i;
        for (i = 0; i < this._free; ++i) {
            this._heap[i].iterator.reset();
            this._heap[i].step();
        }
        this._heapSize = this._free;
        for (i = this._heapSize / 2; i >= 0; --i) {
            this.heapify(i);
        }
        this._returnedLast = -1;
        return this.resetPosition();
    }

    private static final class LookAheadIterator {
        public int node;
        public int markedNode;
        public DTMAxisIterator iterator;
        public boolean isStartSet = false;

        public LookAheadIterator(DTMAxisIterator iterator) {
            this.iterator = iterator;
        }

        public int step() {
            this.node = this.iterator.next();
            return this.node;
        }

        public LookAheadIterator cloneIterator() {
            LookAheadIterator clone = new LookAheadIterator(this.iterator.cloneIterator());
            clone.node = this.node;
            clone.markedNode = this.node;
            return clone;
        }

        public void setMark() {
            this.markedNode = this.node;
            this.iterator.setMark();
        }

        public void gotoMark() {
            this.node = this.markedNode;
            this.iterator.gotoMark();
        }
    }
}

