/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.dv.XSSimpleType;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.ErrorHandlerAdaptor;
import com.sun.org.apache.xerces.internal.jaxp.validation.InsulatedValidatorComponent;
import com.sun.org.apache.xerces.internal.jaxp.validation.WrappedSAXException;
import com.sun.org.apache.xerces.internal.jaxp.validation.XNI2SAXEx;
import com.sun.org.apache.xerces.internal.util.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.util.LocatorWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentFilter;
import com.sun.org.apache.xerces.internal.xs.AttributePSVI;
import com.sun.org.apache.xerces.internal.xs.ElementPSVI;
import com.sun.org.apache.xerces.internal.xs.ItemPSVI;
import com.sun.org.apache.xerces.internal.xs.XSTypeDefinition;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

final class ValidatorHandlerImpl
extends ValidatorHandler {
    private final InsulatedValidatorComponent validator;
    private final XMLDocumentFilter validatorFilter;
    private final XNI2SAXEx xni2sax = new XNI2SAXEx();
    private final SymbolTable symbolTable = new SymbolTable();
    private final NamespaceSupport nsContext = new NamespaceSupport();
    private final ValidationManager validationManager = new ValidationManager();
    private final XMLEntityManager entityManager = new XMLEntityManager();
    private final XMLErrorReporter errorReporter = new XMLErrorReporter();
    private ErrorHandler errorHandler;
    private boolean inStartElement;
    private boolean namespacePrefixesFeature = false;
    private final ErrorHandlerAdaptor xercesErrorHandler = new ErrorHandlerAdaptor(){

        protected ErrorHandler getErrorHandler() {
            if (ValidatorHandlerImpl.this.errorHandler == null) {
                return DraconianErrorHandler.theInstance;
            }
            return ValidatorHandlerImpl.this.errorHandler;
        }
    };
    private LSResourceResolver resourceResolver;
    private final XMLComponentManager manager = new XMLComponentManager(){

        public Object getProperty(String string) {
            if (string.equals("http://apache.org/xml/properties/internal/symbol-table")) {
                return ValidatorHandlerImpl.this.symbolTable;
            }
            if (string.equals("http://apache.org/xml/properties/internal/validation-manager")) {
                return ValidatorHandlerImpl.this.validationManager;
            }
            if (string.equals("http://apache.org/xml/properties/internal/error-reporter")) {
                return ValidatorHandlerImpl.this.errorReporter;
            }
            if (string.equals("http://apache.org/xml/properties/internal/error-handler")) {
                return ValidatorHandlerImpl.this.xercesErrorHandler;
            }
            if (string.equals("http://apache.org/xml/properties/internal/entity-manager")) {
                return ValidatorHandlerImpl.this.entityManager;
            }
            if (string.equals("http://apache.org/xml/properties/internal/entity-resolver")) {
                return ValidatorHandlerImpl.this.entityManager;
            }
            throw new XMLConfigurationException(0, string);
        }

        public boolean getFeature(String string) {
            if (string.equals("http://xml.org/sax/features/validation")) {
                return true;
            }
            if (string.equals("http://apache.org/xml/features/continue-after-fatal-error")) {
                return false;
            }
            throw new XMLConfigurationException(0, string);
        }
    };
    private Locator locator;
    private final TypeInfoProvider typeInfoProvider = new TypeInfoProvider(){

        private void checkState() {
            if (!ValidatorHandlerImpl.this.inStartElement) {
                throw new IllegalStateException();
            }
        }

        public TypeInfo getAttributeTypeInfo(int n) {
            this.checkState();
            return this.getAttributeType(n);
        }

        private XSTypeDefinition getAttributeType(int n) {
            this.checkState();
            XMLAttributes xMLAttributes = ValidatorHandlerImpl.this.getCurrentAttributes();
            if (n < 0 || xMLAttributes.getLength() <= n) {
                throw new IndexOutOfBoundsException(Integer.toString(n));
            }
            Augmentations augmentations = xMLAttributes.getAugmentations(n);
            if (augmentations == null) {
                return null;
            }
            AttributePSVI attributePSVI = (AttributePSVI)augmentations.getItem("ATTRIBUTE_PSVI");
            return this.getTypeInfoFromPSVI(attributePSVI);
        }

        public TypeInfo getAttributeTypeInfo(String string, String string2) {
            this.checkState();
            return this.getAttributeTypeInfo(ValidatorHandlerImpl.this.getCurrentAttributes().getIndex(string, string2));
        }

        public TypeInfo getAttributeTypeInfo(String string) {
            this.checkState();
            return this.getAttributeTypeInfo(ValidatorHandlerImpl.this.getCurrentAttributes().getIndex(string));
        }

        public TypeInfo getElementTypeInfo() {
            this.checkState();
            Augmentations augmentations = ValidatorHandlerImpl.this.getCurrentAugmentation();
            if (augmentations == null) {
                return null;
            }
            ElementPSVI elementPSVI = (ElementPSVI)augmentations.getItem("ELEMENT_PSVI");
            return this.getTypeInfoFromPSVI(elementPSVI);
        }

        private XSTypeDefinition getTypeInfoFromPSVI(ItemPSVI itemPSVI) {
            XSTypeDefinition xSTypeDefinition;
            if (itemPSVI == null) {
                return null;
            }
            if (itemPSVI.getValidity() == 2 && (xSTypeDefinition = itemPSVI.getMemberTypeDefinition()) != null) {
                return xSTypeDefinition;
            }
            xSTypeDefinition = itemPSVI.getTypeDefinition();
            if (xSTypeDefinition != null) {
                return xSTypeDefinition;
            }
            return null;
        }

        public boolean isIdAttribute(int n) {
            this.checkState();
            XSSimpleType xSSimpleType = (XSSimpleType)this.getAttributeType(n);
            if (xSSimpleType == null) {
                return false;
            }
            return xSSimpleType.isIDType();
        }

        public boolean isSpecified(int n) {
            this.checkState();
            return ValidatorHandlerImpl.this.getCurrentAttributes().isSpecified(n);
        }
    };
    private final XMLAttributes xa = new XMLAttributesImpl();

    ValidatorHandlerImpl(InsulatedValidatorComponent insulatedValidatorComponent) {
        this.validator = insulatedValidatorComponent;
        this.validatorFilter = insulatedValidatorComponent.getValidator();
        this.errorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
    }

    private final Augmentations getCurrentAugmentation() {
        return this.xni2sax.getCurrentAugmentation();
    }

    private final XMLAttributes getCurrentAttributes() {
        return this.xni2sax.getCurrentAttributes();
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this.namespacePrefixesFeature;
        }
        return super.getFeature(string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this.namespacePrefixesFeature = bl;
            return;
        }
        super.setFeature(string, bl);
    }

    public boolean isValidSoFar() {
        return !this.xercesErrorHandler.hadError();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resourceResolver = lSResourceResolver;
    }

    public LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public final void setContentHandler(ContentHandler contentHandler) {
        this.xni2sax.setContentHandler(contentHandler);
        if (contentHandler == null) {
            this.validatorFilter.setDocumentHandler(null);
        } else {
            this.validatorFilter.setDocumentHandler(this.xni2sax);
        }
    }

    public final ContentHandler getContentHandler() {
        return this.xni2sax.getContentHandler();
    }

    public void startDocument() throws SAXException {
        try {
            this.resetComponents();
            LocatorWrapper locatorWrapper = this.locator == null ? null : new LocatorWrapper(this.locator);
            this.errorReporter.setDocumentLocator(locatorWrapper);
            this.validatorFilter.startDocument(locatorWrapper, null, this.nsContext, null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    private void resetComponents() {
        this.xercesErrorHandler.reset();
        this.nsContext.reset();
        this.errorReporter.reset(this.manager);
        this.validator.reset(this.manager);
    }

    public void endDocument() throws SAXException {
        try {
            this.validatorFilter.endDocument(null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.inStartElement = true;
            this.validatorFilter.startElement(this.createQName(string, string2, string3), this.createAttributes(attributes), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
        finally {
            this.inStartElement = false;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.validatorFilter.endElement(this.createQName(string, string2, string3), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.validatorFilter.characters(new XMLString(cArray, n, n2), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.validatorFilter.ignorableWhitespace(new XMLString(cArray, n, n2), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void startPrefixMapping(String string, String string2) {
        this.nsContext.pushContext();
        this.nsContext.declarePrefix(this.symbolize(string), this.symbolize(string2));
    }

    public void endPrefixMapping(String string) {
        this.nsContext.popContext();
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            this.validatorFilter.processingInstruction(this.symbolize(string), this.createXMLString(string2), null);
        }
        catch (WrappedSAXException wrappedSAXException) {
            throw wrappedSAXException.exception;
        }
    }

    public void skippedEntity(String string) {
        ContentHandler contentHandler = this.getContentHandler();
        if (contentHandler != null) {
            this.skippedEntity(string);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public TypeInfoProvider getTypeInfoProvider() {
        return this.typeInfoProvider;
    }

    private String symbolize(String string) {
        if (string == null) {
            return null;
        }
        return this.symbolTable.addSymbol(string);
    }

    private QName createQName(String string, String string2, String string3) {
        int n;
        if (string2.length() == 0) {
            string = "";
            string2 = string3;
        }
        String string4 = (n = string3.indexOf(58)) < 0 ? null : string3.substring(0, n);
        if (string != null && string.length() == 0) {
            string = null;
        }
        return new QName(this.symbolize(string4), this.symbolize(string2), this.symbolize(string3), this.symbolize(string));
    }

    private XMLAttributes createAttributes(Attributes attributes) {
        this.xa.removeAllAttributes();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            int n2 = this.xa.addAttribute(this.createQName(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i)), attributes.getType(i), attributes.getValue(i));
            this.xa.setSpecified(n2, true);
        }
        return this.xa;
    }

    private XMLString createXMLString(String string) {
        return new XMLString(string.toCharArray(), 0, string.length());
    }

    public void reset() {
        this.resetComponents();
        this.errorHandler = null;
        this.resourceResolver = null;
    }
}

