<?php
/**
 * アップグレードFlavor画面(1)クラス
 *
 * アップグレードFlavor画面(1)を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2012 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( 'upgrade_base.inc' );

  class page01 extends upgrade_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * チェック情報格納用変数
     * @access private
     * @var    array
     */
    private $checklist;
    /**
     * チェック結果格納用変数
     * @access private
     * @var    array
     */
    private $checkresult;
    /**
     * エラー発生状況格納用変数
     * @access private
     * @var    boolean
     */
    private $errStatus;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 前画面のCageが現在のCageと同一でない or 前画面のActが「upgrade」 and 「page01」 and 「page02」でない場合、
      // アップグレードFlavorに飛ばす
      $tmp_cage      = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_cage_self = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      $tmp_act       = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != $tmp_cage_self or  ( $tmp_act != 'upgrade' and  $tmp_act != 'page01' and  $tmp_act != 'page02' ) )
      {
        $this->obj_util->redirectTo( 'upgrade', $tmp_cage_self );
        return false;
      } // end of if

      // チェック対象をセットする
      // 他にチェック対象があれば、この配列に加えてください。
      // path: チェック対象となるパス / stat: あるべき状態（writable: 書込可 / readable: 読込可）
      // readableを指定したとき、その対象が書込可の場合はNGとなります
      clearstatcache();
      $tmp_base = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->checklist = array(
                                array(
                                       'path' => $tmp_base
                                     , 'stat' => 'writable'
                                     , 'pass' => false
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target
                                     , 'stat' => 'writable'
                                     , 'pass' => false
                                     )
                              , array(
                                       'path' => RISOLUTO_DOCROOT . '/js/' . $this->target . '_ckeditor.js'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog_ckeditor.js' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_BATCH . $this->target . '_posttweet.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog_posttweet.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_BATCH . $this->target . '_posttweet.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog_posttweet.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . $this->target . '_version'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog_version' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_CONF . $this->target . '.ini'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog.ini' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . 'admin/menu/00005_' . $this->target . '.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/00005_simpleblog.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/AUTHORS'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/AUTHORS' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/LICENSE'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/LICENSE' ) ? true : false )
                                     )
// ToDo: UNCOMMENT HERE for next release
//                              , array(
//                                       'path' => RISOLUTO_USERLAND . $this->target . '/blog_menubar.tpl'
//                                     , 'stat' => 'writable'
//                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blog_menubar.tpl' ) ? true : false )
//                                     )
// ToDo: UNCOMMENT HERE for next release
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_entry.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogadd_entry.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogadd_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogcomment.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogcomment.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogcomment.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogcomment.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogdel_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogdel_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogdel_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogdel_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogdel_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogdel_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogdel_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogdel_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/bloglist.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/bloglist.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/bloglist.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/bloglist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_complete.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_complete.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_complete.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_complete.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_confirm.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_confirm.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_confirm.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_confirm.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_entry.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_entry.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogmod_entry.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogmod_entry.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogview.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogview.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/blogview.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/blogview.tpl' ) ? true : false )
                                     )
// ToDo: UNCOMMENT HERE for next release
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_complete.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_complete.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_complete.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_complete.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_confirm.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_confirm.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_confirm.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_confirm.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_entry.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_entry.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categoryadd_entry.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categoryadd_entry.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorydel_complete.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorydel_complete.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorydel_complete.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorydel_complete.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorydel_confirm.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorydel_confirm.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorydel_confirm.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorydel_confirm.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorylist.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorylist.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorylist.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorylist.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_complete.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_complete.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_complete.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_complete.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_confirm.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_confirm.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_confirm.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_confirm.tpl' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_entry.php'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_entry.php' ) ? true : false )
//                                      )
//                               , array(
//                                        'path' => RISOLUTO_USERLAND . $this->target . '/categorymod_entry.tpl'
//                                      , 'stat' => 'writable'
//                                      , 'pass' => ( !file_exists( $tmp_base . '/file/categorymod_entry.tpl' ) ? true : false )
//                                      )
// ToDo: UNCOMMENT HERE for next release
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/comment_add.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/comment_add.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/comment_del.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/comment_del.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/comment_ng.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/comment_ng.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/comment_notification.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/comment_notification.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/comment_ok.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/comment_ok.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/commentlist.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/commentlist.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/commentlist.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/commentlist.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/rss.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/rss.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/rss_1.0.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/rss_1.0.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/rss_2.0.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/rss_2.0.tpl' ) ? true : false )
                                     )
// ToDo: UNCOMMENT HERE for next release
//                              , array(
//                                       'path' => RISOLUTO_USERLAND . $this->target . '/rss_2.0_ya.tpl'
//                                     , 'stat' => 'writable'
//                                     , 'pass' => ( !file_exists( $tmp_base . '/file/rss_2.0_ya.tpl' ) ? true : false )
//                                     )
// ToDo: UNCOMMENT HERE for next release
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/simpleblog_base.inc'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/simpleblog_base.inc' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/tb.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/tb.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackback_del.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackback_del.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackback_ng.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackback_ng.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackback_notification.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackback_notification.tpl' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackback_ok.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackback_ok.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackbacklist.php'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackbacklist.php' ) ? true : false )
                                     )
                              , array(
                                       'path' => RISOLUTO_USERLAND . $this->target . '/trackbacklist.tpl'
                                     , 'stat' => 'writable'
                                     , 'pass' => ( !file_exists( $tmp_base . '/file/trackbacklist.tpl' ) ? true : false )
                                     )
                              );

      // チェックメソッドを呼び出し、結果を整形
      foreach( $this->checklist as $dat )
      {
        if ( $dat[ 'pass' ] )
        {
          continue;
        } // end of if

        $tmp_result = $this->obj_util->statChecker( $dat );
        if ( $tmp_result[ 'result' ] == 'NG' )
        {
          $this->errStatus = 'NG';
        } // end of if
        $this->checkresult[] = $tmp_result;
      } // end of foreach

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // ヘッダ情報をセット
      $html_header[ 'robots' ] = 'NOINDEX,NOFOLLOW';
      $html_header[ 'css'    ] = array( './css/common.css' );
      $html_header[ 'title'  ] = 'アップグレードFlavor(1)';

      // アサイン
      $this->smarty->assign ( 'header',    $html_header       );
      $this->smarty->assign ( 'checklist', $this->checkresult );
      $this->smarty->assign ( 'err',       $this->errStatus   );

      $this->smarty->assign ( 'cage',   str_replace( DIRECTORY_SEPARATOR, '.' , $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'page01.tpl' );

      return true;

    } // end of function:view()

  } // end of class:page01
?>
