<?php
/**
 * ブログコメント表示画面クラス
 *
 * ブログコメント表示画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class blogcomment extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisoluteDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'blogid' ] = null;

      // ブログID
      if ( isset( $_GET[ 'blogid' ] ) )
      {
        $tmp_entered[ 'blogid' ] = strip_tags( trim( $_GET[ 'blogid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // ブログID（ブログIDが不正）
      if ( $tmp_entered[ 'blogid' ] == null or ! is_numeric( $tmp_entered[ 'blogid' ] ) )
      {
        // エラーの場合、例外を投げる
        throw new Exception( 'Invalid blogid' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT  `user`.`user_name`                              -- ユーザ名
                    , `blog`.`blog_id`                                -- ブログID
                    , `blog`.`blog_title`                             -- ブログタイトル
                    , `blog`.`blog_body`                              -- ブログ本文
                    , `blog`.`post_datetime`                          -- 投稿日
                FROM `risoluto_t_user`   user
                   , `simpleblog_t_blog` blog
               WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                 AND (
                          TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                       OR (
                            `blog`.`end_datetime` = '0000-00-00 00:00:00'
                          )
                     )
                 AND `blog`.`user_id` = `user`.`user_id`
                 AND `blog`.`blog_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'blogid' ]
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          // エラーの場合は例外を投げる
          throw new Exception( 'SELECT Blog data Failure' );
          return false;
        } // end of if
        else
        {
          $this->gotDat[ 'blogdat' ] = $tmp_result;

          //--- コメントの取得
          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              SELECT `comment`.`commentator` -- お名前
                   , `comment`.`comment`     -- コメント
                   , `comment`.`ctime`       -- 作成日
                FROM `simpleblog_t_comment` comment
               WHERE `comment`.`status`  = 1
                 AND `comment`.`blog_id` = ?
            ORDER BY `comment`.`comment_id` ASC

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                          $tmp_entered[ 'blogid' ]
                        );
          // SQLを実行
          $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
          if ( PEAR::isError( $tmp_result ) )
          {
            // エラーの場合でも無視する
            $this->gotDat[ 'commentdat' ] = null;
          } // end of if
          else
          {
            $this->gotDat[ 'commentdat' ] = $tmp_result;
          } // end of else



          //--- トラックバックの取得
          // SQL文を組み立てる
          $sql =<<<End_Of_SQL

              SELECT `tb`.`url`      -- URL
                   , `tb`.`blogname` -- ブログ名
                   , `tb`.`title`    -- タイトル
                   , `tb`.`body`     -- 本文
                FROM `simpleblog_t_trackback` tb
               WHERE `tb`.`status`  = 1
                 AND `tb`.`blog_id` = ?
            ORDER BY `tb`.`trackback_id` ASC

End_Of_SQL;

          // パラメタも用意する
          $param = array(
                          $tmp_entered[ 'blogid' ]
                        );
          // SQLを実行
          $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
          if ( PEAR::isError( $tmp_result ) )
          {
            // エラーの場合でも無視する
            $this->gotDat[ 'tbdat' ] = null;
          } // end of if
          else
          {
            $this->gotDat[ 'tbdat' ] = $tmp_result;
          } // end of else

        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      // ブログタイトルの取得
      $simpleblog_conf = new RisolutoConf();
      $simpleblog_conf->parse( RISOLUTO_CONF . 'simpleblog.ini' );
      $this->gotDat[ 'title' ] = $simpleblog_conf->get( 'BLOGINFO', 'title' );

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $headers            = $this->obj_util->getHeader();
      $headers[ 'title' ] = $this->gotDat[ 'title' ] . "：" . $this->gotDat[ 'blogdat' ][ 'blog_title' ] . "（" . $headers[ 'title' ] . "）";
      $this->smarty->assign ( 'header', $headers );

      $this->smarty->assign ( 'blog_title',    $this->gotDat[ 'blogdat' ][ 'blog_title'    ] );
      $this->smarty->assign ( 'user_name',     $this->gotDat[ 'blogdat' ][ 'user_name'     ] );
      $this->smarty->assign ( 'post_datetime', $this->gotDat[ 'blogdat' ][ 'post_datetime' ] );
      $this->smarty->assign ( 'blog_body',     $this->gotDat[ 'blogdat' ][ 'blog_body'     ] );
      $this->smarty->assign ( 'blog_id',       $this->gotDat[ 'blogdat' ][ 'blog_id'       ] );

      $this->smarty->assign ( 'commentlist',   $this->gotDat[ 'commentdat'  ] );
      $this->smarty->assign ( 'tblist',        $this->gotDat[ 'tbdat'       ] );
      $this->smarty->assign ( 'baseurl',       $this->obj_util->getBaseUrl()  );
      $this->smarty->assign ( 'lapsed_days',   ( strtotime( date("Ymd") ) - strtotime( $this->gotDat[ 'blogdat' ][ 'post_datetime' ] ) ) / ( 24 * 60 * 60 )  );

      $this->smarty->assign ( 'mycage',        str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) ) );

      // 表示
      $this->smarty->display( 'blogcomment.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogcomment
?>
