<?php
/**
 * ヘッダ削除完了画面クラス
 *
 * ヘッダ削除完了画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headerdel_complete extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.site」でない or 前画面のActが「headerdel_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'headerdel_confirm' ) )
      {
        $this->obj_util->redirectTo( 'headerlist', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッションから値を取得し、セッションを削除
      //------------------------------------------------------------------------
      $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisolutoDb();



      //------------------------------------------------------------------------
      // 渡されてきた情報でデータベースを更新する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // トランザクションを開始
        $this->obj_db->dbBeginTransaction();

        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              DELETE FROM `risoluto_t_headerinfo`
               WHERE `header_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'header_id' ]
                      );

        // Insertを実行
        $tmp_delete_result = $this->obj_db->dbExecSQL( $sql, $param );
        if ( PEAR::isError( $tmp_delete_result ) )
        {
          // エラーの場合はロールバックしてコネクションを閉じ、例外を投げる
          $this->obj_db->dbRollback();
          $this->obj_db->dbDisConnect();
          throw new Exception( 'Delete Failure' );
          return false;
        } // end of if
        else
        {
          // 正常に実行できた場合はコミットしてコネクションを閉じる
          $this->obj_db->dbCommit();
          $this->obj_db->dbDisConnect();
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage', $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',  $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      // 表示
      $this->smarty->display( 'headerdel_complete.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headerdel_complete

?>
