<?php
/**
 * ブログ記事情報画面クラス
 *
 * ブログ記事情報画面を実現するためのクラス
 *
 * @package   simpleblog
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "simpleblog_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  /**
   * ページャクラス
   */
  require_once( 'Pager.php' );

  class blogview extends simpleblog_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_db   = new RisolutoDb();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      //------------------------------------------------------------------------
      // ユーザ指定の処理
      //------------------------------------------------------------------------
      // ユーザIDが指定されていたら抽出対象のブログを当該カテゴリのみにする
      if ( isset( $_GET[ 'user' ] ) and preg_match( '/^[[:digit:]].*$/', $_GET[ 'user' ] ) )
      {
        $cond_user = ' AND `blog`.`user_id` = ' . htmlentities( trim( $_GET[ 'user' ] ), ENT_QUOTES, 'UTF-8' );
      } // end of if
      else
      {
        $cond_user = '';
      } // end of else

      //------------------------------------------------------------------------
      // カテゴリ指定の処理
      //------------------------------------------------------------------------
      // カテゴリが指定されていたら抽出対象のブログを当該カテゴリのみにする
      if ( isset( $_GET[ 'cat' ] ) and preg_match( '/^[[:digit:]].*$/', $_GET[ 'cat' ] ) )
      {
        $cond_category = ' AND `blog`.`category_id` = ' . htmlentities( trim( $_GET[ 'cat' ] ), ENT_QUOTES, 'UTF-8' );
      } // end of if
      else
      {
        $cond_category = '';
      } // end of else

      //------------------------------------------------------------------------
      // 日付指定の処理
      //------------------------------------------------------------------------
      // カテゴリが指定されていたら抽出対象のブログを当該カテゴリのみにする
      if ( isset( $_GET[ 'date' ] ) and preg_match( '/^[[:digit:]]{6}$/', $_GET[ 'date' ] ) )
      {
        $cond_date = ' AND CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) ) = '
                   . htmlentities( trim( $_GET[ 'date' ] ), ENT_QUOTES, 'UTF-8' );
      } // end of if
      else
      {
        $cond_date = '';
      } // end of else



      //------------------------------------------------------------------------
      // DBから情報を取得する
      //------------------------------------------------------------------------

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {
        // テーブル名を可変にできるよう対応
        $tmp_t_blog     = $this->mycage . '_t_blog';
        $tmp_t_comment  = $this->mycage . '_t_comment';
        $tmp_t_category = $this->mycage . '_t_category';

        // ブログ情報の取得
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_name`                              -- ユーザ名
                   , `user`.`user_id`                                -- ユーザID
                   , `blog`.`blog_id`                                -- ブログID
                   , `blog`.`blog_title`                             -- ブログタイトル
                   , `blog`.`blog_body`                              -- ブログ本文
                   , `blog`.`post_datetime`                          -- 投稿日
                   , `comment`.`cnt`                                 -- コメント数
                   , `blog`.`category_id`                            -- カテゴリID
                   , `cat`.`category_name`                           -- カテゴリ名
                FROM `risoluto_t_user` user
                   , $tmp_t_category cat
                   , $tmp_t_blog blog
                     LEFT JOIN
                     (
                        SELECT `comment`.`blog_id`
                             , count( `comment`.`blog_id` ) as cnt
                          FROM $tmp_t_comment comment
                         WHERE `comment`.`status` = 1
                      GROUP BY `comment`.`blog_id`
                     ) comment
                     ON `comment`.`blog_id` = `blog`.`blog_id`
               WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                 AND (
                          TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                       OR (
                            `blog`.`end_datetime` = '0000-00-00 00:00:00'
                          )
                     )
                 $cond_date
                 $cond_user
                 AND `blog`.`user_id`     = `user`.`user_id`
                 $cond_category
                 AND `blog`.`category_id` = `cat`.`category_id`
            ORDER BY `blog`.`post_datetime` DESC
                   , `comment`.`cnt`        DESC
                   , `blog`.`blog_id`       DESC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $tmp_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $tmp_result ) )
        {
          throw new Exception( 'get blog dat Failure' );
          return false;
        } // end of if



        // カテゴリ情報の取得
        $sql =<<<End_Of_SQL

              SELECT `cat`.`category_id`   -- カテゴリID
                   , `cat`.`category_name` -- カテゴリ名
                   , `blog`.`cnt`          -- 件数
                FROM $tmp_t_category cat
                     LEFT JOIN
                     (
                        SELECT `blog`.`category_id`
                             , count( `blog`.`category_id` ) as cnt
                          FROM $tmp_t_blog blog
                         WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                           AND (
                                 TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                 OR (
                                      `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                    )
                               )
                      GROUP BY `blog`.`category_id`
                     ) blog
                     ON `cat`.`category_id` = `blog`.`category_id`
            ORDER BY `blog`.`cnt`        DESC
                   , `cat`.`category_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $category4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $category4menubar_result ) )
        {
          throw new Exception( 'get category dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_category4menubar = array();
          foreach( $category4menubar_result as $dat )
          {
            $tmp_category4menubar[ $dat[ 'category_id' ] ] = array(
                                                                    'categoryname' => $dat[ 'category_name' ]
                                                                  , 'cnt'          => $dat[ 'cnt' ]
                                                                  );
          } // end of foreach
        } // end of else



        // 執筆者情報の取得
        $sql =<<<End_Of_SQL

              SELECT `user`.`user_id`   -- ユーザID
                   , `user`.`user_name` -- ユーザ名
                   , `blog`.`cnt`       -- 件数
                FROM `risoluto_t_user` user
                     LEFT JOIN
                     (
                        SELECT `blog`.`user_id`
                             , count( `blog`.`user_id` ) as cnt
                          FROM $tmp_t_blog blog
                         WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                           AND (
                                 TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                 OR (
                                      `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                    )
                               )
                      GROUP BY `blog`.`user_id`
                     ) blog
                     ON `user`.`user_id` = `blog`.`user_id`
            ORDER BY `blog`.`cnt`     DESC
                   , `user`.`user_id` ASC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $user4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $user4menubar_result ) )
        {
          throw new Exception( 'get author dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_user4menubar = array();
          foreach( $user4menubar_result as $dat )
          {
            $tmp_user4menubar[ $dat[ 'user_id' ] ] = array(
                                                            'username' => $dat[ 'user_name' ]
                                                          , 'cnt'      => $dat[ 'cnt' ]
                                                          );
          } // end of foreach
        } // end of else



        // 日付情報の取得
        $sql =<<<End_Of_SQL

              SELECT *
                FROM (
                       SELECT SUBSTR( `blog`.`post_datetime`, 1, 4 )                                                            as year
                            , SUBSTR( `blog`.`post_datetime`, 6, 2 )                                                            as month
                            , CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) )          as date
                            , count( CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) ) ) as cnt
                         FROM $tmp_t_blog blog
                        WHERE TIMEDIFF( NOW(), `blog`.`open_datetime` ) >= 0
                          AND (
                                TIMEDIFF( NOW(), `blog`.`end_datetime` ) < 0
                                OR (
                                     `blog`.`end_datetime` = '0000-00-00 00:00:00'
                                   )
                              )
                     GROUP BY CONCAT( SUBSTR( `blog`.`post_datetime`, 1, 4 ), SUBSTR( `blog`.`post_datetime`, 6, 2 ) )
                     ) result
            ORDER BY `result`.`date` DESC

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                      );

        // SQLを実行
        $date4menubar_result = $this->obj_db->dbGetAll( $sql, $param );
        if ( PEAR::isError( $user4menubar_result ) )
        {
          throw new Exception( 'get date dat Failure' );
          return false;
        } // end of if
        else
        {
          $tmp_date4menubar = array();
          foreach( $date4menubar_result as $dat )
          {
            $tmp_date4menubar[ $dat[ 'date' ] ] = array(
                                                         'year'  => $dat[ 'year' ]
                                                       , 'month' => $dat[ 'month' ]
                                                       , 'cnt'   => $dat[ 'cnt' ]
                                                       );
          } // end of foreach
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else


      // 取得した情報を表示に適した形に加工する
      $tmp_result_cooked = array();
      $tmp_baseurl       = $this->obj_util->getBaseUrl();
      $tmp_mycage        = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'currentcage' ) );
      for( $cnt = 0 ; $cnt < count( $tmp_result ) ; $cnt ++ )
      {
        $tmp_permanentlink = $tmp_baseurl . '?cage=' . $tmp_mycage . '&amp;act=blogcomment&amp;blogid=' . $tmp_result[ $cnt ][ 'blog_id' ];

        array_push( $tmp_result_cooked, array(
                                               'user_name'         => $tmp_result[ $cnt ][ 'user_name'     ]
                                             , 'user_id'           => $tmp_result[ $cnt ][ 'user_id'       ]
                                             , 'blog_id'           => $tmp_result[ $cnt ][ 'blog_id'       ]
                                             , 'blog_title'        => $tmp_result[ $cnt ][ 'blog_title'    ]
                                             , 'enc_blog_title'    => rawurlencode( $tmp_result[ $cnt ][ 'blog_title' ] )
                                             , 'blog_body'         => stripslashes( $tmp_result[ $cnt ][ 'blog_body' ] )
                                             , 'post_datetime'     => $tmp_result[ $cnt ][ 'post_datetime' ]
                                             , 'cnt'               => $tmp_result[ $cnt ][ 'cnt'           ]
                                             , 'permanentlink'     => $tmp_permanentlink
                                             , 'enc_permanentlink' => rawurlencode( $tmp_permanentlink )
                                             , 'categoryid'        => $tmp_result[ $cnt ][ 'category_id'   ]
                                             , 'categoryname'      => $tmp_result[ $cnt ][ 'category_name' ]
                                             )
                  );
      } // end of for



      //------------------------------------------------------------------------
      // pagerのセットアップ
      //------------------------------------------------------------------------
      // pagerオプション値を連想配列にセット
      $pager_params = array(
                       'itemData'              => $tmp_result_cooked
                     , 'urlVar'                => 'p'
                     , 'mode'                  => $this->obj_adminconf->get( 'PAGER', 'mode'          )
                     , 'perPage'               => $this->obj_adminconf->get( 'PAGER', 'perPage'       )
                     , 'delta'                 => $this->obj_adminconf->get( 'PAGER', 'delta'         )
                     , 'prevImg'               => $this->obj_adminconf->get( 'PAGER', 'prevImg'       )
                     , 'nextImg'               => $this->obj_adminconf->get( 'PAGER', 'nextImg'       )
                     , 'firstPagePre'          => $this->obj_adminconf->get( 'PAGER', 'firstPagePre'  )
                     , 'firstPageText'         => $this->obj_adminconf->get( 'PAGER', 'firstPageText' )
                     , 'firstPagePost'         => $this->obj_adminconf->get( 'PAGER', 'firstPagePost' )
                     , 'lastPagePre'           => $this->obj_adminconf->get( 'PAGER', 'lastPagePre'   )
                     , 'lastPageText'          => $this->obj_adminconf->get( 'PAGER', 'lastPageText'  )
                     , 'lastPagePost'          => $this->obj_adminconf->get( 'PAGER', 'firstPagePost' )
                     , 'separator'             => $this->obj_adminconf->get( 'PAGER', 'separator'     )
                     , 'spacesBeforeSeparator' => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt'  )
                     , 'spacesAfterSeparator'  => $this->obj_adminconf->get( 'PAGER', 'spacesSepCnt'  )
                     , 'clearIfVoid'           => ( !is_null( $this->obj_adminconf->get( "PAGER", "clearIfVoid" ) ) ? true : false )
      );

      // ページャのインスタンスを生成し、必要なデータを生成する
      $pager                        = & pager::factory( $pager_params );
      $this->gotDat[ 'pager_link' ] = $pager->getLinks();

      // ブログデータについては、一番外にある配列の添え字をゼロスタートへリセットする
      $this->gotDat[ 'pager_dat'  ] = array();
      foreach( $pager->getPageData() as $key => $val )
      {
        array_push( $this->gotDat[ 'pager_dat'  ], $val );
      }

      // ブログタイトルの取得
      $simpleblog_conf = new RisolutoConf();
      $simpleblog_conf->parse( RISOLUTO_CONF . $this->mycage . '.ini' );
      $this->gotDat[ 'title' ] = $simpleblog_conf->get( 'BLOGINFO', 'title' );

      // 付随情報の取得
      $this->gotDat[ 'mycage'  ] = $this->mycage;
      $this->gotDat[ 'baseURL' ] = $this->obj_util->getBaseUrl();

      // サイドのmenubarに表示する内容を構成
      $tmp_menubar                = new Smarty;
      $tmp_menubar->template_dir  = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $tmp_menubar->config_dir    = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $tmp_menubar->compile_dir   = RISOLUTO_CACHE;
      $tmp_menubar->cache_dir     = RISOLUTO_CACHE;
      $tmp_menubar->caching       = false;
      $tmp_menubar->debugging     = false;
      $tmp_menubar->force_compile = true;
      $tmp_menubar->compile_check = true;

      $tmp_menubar->assign( 'categorylist', $tmp_category4menubar );
      $tmp_menubar->assign( 'userlist',     $tmp_user4menubar     );
      $tmp_menubar->assign( 'datelist',     $tmp_date4menubar     );
      $tmp_menubar->assign( 'mycage',       $this->mycage         );

      $this->gotDat[ 'menubar' ] = $tmp_menubar->fetch( 'blog_menubar.tpl' );



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {

      // アサイン
      $headers            = $this->obj_util->getHeader();
      $headers[ 'title' ] = $this->gotDat[ 'title' ] . "（" . $headers[ 'title' ] . '）';
      $this->smarty->assign ( 'header', $headers );

      $this->smarty->assign ( 'bloglist',     $this->gotDat[ 'pager_dat'  ] );
      $this->smarty->assign ( 'pagerlink',    $this->gotDat[ 'pager_link' ][ 'all' ] );

      $this->smarty->assign ( 'menubar',      $this->gotDat[ 'menubar' ] );

      $this->smarty->assign ( 'mycage',       $this->gotDat[ 'mycage'  ] );
      $this->smarty->assign ( 'baseURL',      $this->gotDat[ 'baseURL' ] );
      $this->smarty->assign ( 'blogname',     $this->gotDat[ 'title' ] );
      $this->smarty->assign ( 'enc_blogname', rawurlencode( $this->gotDat[ 'title' ] ) );

      // 表示
      $this->smarty->display( 'blogview.tpl' );

      return true;

    } // end of function:view()

  } // end of class:blogview
?>
