<?php
/**
 * サイト状態確認画面クラス
 *
 * サイト状態確認画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );

  class sitestat_complete extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.stat」でない or 前画面のActが「sitestat_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'sitestat_confirm' ) )
      {
        $this->obj_util->redirectTo( 'sitestat_select', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッションから値を取得し、設定を変更する
      //------------------------------------------------------------------------
      // 値を取得したらセッションを消す
      $tmp_entered[ 'change' ] = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'lastact' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'lastact' ) );

      // 一度想定しうるすべてのファイルを消す
      $this->obj_util->fileOperator( 'unlink', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'ServiceStop'        ) );
      $this->obj_util->fileOperator( 'unlink', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'AdminOnly'          ) );
      $this->obj_util->fileOperator( 'unlink', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'UserOnly'           ) );
      $this->obj_util->fileOperator( 'unlink', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'CurrentSessionOnly' ) );

      // 指定されたモードに変更する
      switch( $tmp_entered[ 'change' ] )
      {
        // 準公開状態（すでにセッションを持っている場合のみ許可）
        case 1:
          $this->obj_util->fileOperator( 'make', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'CurrentSessionOnly' ) );
          break;

        // 準公開状態（ログインユーザのみ許可）
        case 2:
          $this->obj_util->fileOperator( 'make', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'UserOnly'           ) );
          break;

        // 閉鎖状態（管理者のみ許可）
        case 3:
          $this->obj_util->fileOperator( 'make', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'AdminOnly'          ) );
          break;

        // 閉鎖状態（スーパバイザのみ許可）
        case 4:
          $this->obj_util->fileOperator( 'make', RISOLUTO_SYSROOT . $this->obj_conf->get( 'SERVICESTOP', 'ServiceStop'        ) );
          break;
      } // end of switch


      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage', $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',  $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      // 表示
      $this->smarty->display( 'sitestat_complete.tpl' );

      return true;

    } // end of function:view()

  } // end of class:sitestat_complete

?>
