<?php

  require_once( 'Smarty.class.php' );
  require_once( RISOLUTO_FUNC . 'risoluto_session.php' );
  require_once( RISOLUTO_FUNC . 'risoluto_conf.php' );
  require_once( RISOLUTO_FUNC . 'risoluto_util.php' );

  abstract class skeleton_base
  {
    protected $smarty;
    protected $obj_sess;
    protected $obj_util;
    protected $obj_conf;

    abstract function model();
    abstract function view();

    public function __construct()
    {
    }

    public function __clone()
    {
    }

    public function init()
    {
      $this->obj_sess = RisolutoSession::singleton();
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );
      $this->obj_util = RisolutoUtils::singleton();

      $this->smarty                = new Smarty;
      $this->smarty->template_dir  = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->smarty->config_dir    = RISOLUTO_USERLAND . $this->obj_sess->sessLoad( 'currentcage' );
      $this->smarty->compile_dir   = RISOLUTO_CACHE;
      $this->smarty->cache_dir     = RISOLUTO_CACHE;
      $this->smarty->caching       = false;
      $this->smarty->debugging     = false;
      $this->smarty->force_compile = true;
      $this->smarty->compile_check = true;

      return true;
    }

    public function errHandler()
    {
      $this->obj_util->redirectTo( $this->obj_conf->get( 'COMMON', 'error_act'  )
                                 , $this->obj_conf->get( 'COMMON', 'error_cage' ) );
      return true;
    }

    public function clean() {
      unset( $this->smarty );
      unset( $this->obj_sess );
      unset( $this->obj_conf );
      unset( $this->obj_util );
      return true;
    }

  }
?>
