<?php
/**
 * 新規ヘッダ情報追加画面クラス
 *
 * 新規ヘッダ情報追加画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2011 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headeradd_entry extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------

      // セッションからエラーメッセージと入力値を取得し、削除する
      $this->gotDat = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentact' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentact' ) );

      // 前画面のCageが「admin.site」で前画面のActが「headeradd_confirm」の場合、セッションから値を取り出して消す
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( empty( $this->gotDat ) and $tmp_cage == 'admin.site' and $tmp_act == 'headeradd_confirm' )
      {
        $this->gotDat = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'lastact' ) );
        $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'lastact' ) );
      } // end of if

      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',           $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage',        $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',         $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'entered',          $this->gotDat );

      // 表示
      $this->smarty->display( 'headeradd_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headeradd_entry

?>
