/* Risolutoシステムテーブル */

CREATE TABLE IF NOT EXISTS risoluto_m_vendors
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `vender_id`          int unsigned   NOT NULL
    , `vender_name`        varchar(255)
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `vender_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS risoluto_m_flavors
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `flavor_id`          int unsigned   NOT NULL
    , `flavor_description` text
    , `flavor_authors`     text
    , `flavor_url`         varchar(255)
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `flavor_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS risoluto_t_flavors
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `vender_id`          int unsigned   NOT NULL
    , `flavor_id`          int unsigned   NOT NULL
    , `internal_version`   int unsigned   NOT NULL
    , `display_version`    varchar(100)
    , `prefix`             varchar(100)
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `vender_id`
                   , `flavor_id`
                   , `internal_version`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS risoluto_t_headerinfo
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `header_id`          int unsigned   NOT NULL
    , `act`                varchar(255)   NOT NULL
    , `cage`               varchar(255)
    , `robot_index`        tinyint        DEFAULT 0
    , `robot_follow`       tinyint        DEFAULT 0
    , `title`              text
    , `description`        text
    , `keywords`           text
    , `author`             text
    , `javascript`         text
    , `css`                text
    , `favicon`            text
    , PRIMARY KEY  (
                     `header_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS `risoluto_m_zipcode`
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `zipcd_1`            varchar(3)
    , `zipcd_2`            varchar(4)
    , `prefcd`             varchar(5)
    , `prefname`           varchar(10)
    , `cityname`           varchar(255)
    , `cityname_kn`        varchar(255)
    , `areaname`           varchar(255)
    , `areaname_kn`        varchar(255)
    , `active_flg`         varchar(1)
    ,  PRIMARY KEY  (
                      `zipcd_1`
                    , `zipcd_2`
                    )
) ENGINE=InnoDB CHARACTER SET utf8;

/* ログイン関連テーブル */

CREATE TABLE IF NOT EXISTS risoluto_m_group
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `group_id`           int unsigned   NOT NULL
    , `group_name`         varchar(100)   NOT NULL
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `group_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

CREATE TABLE IF NOT EXISTS risoluto_t_user
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `user_id`            int unsigned   NOT NULL
    , `group_id`           int unsigned   NOT NULL
    , `user_name`          varchar(100)   NOT NULL
    , `password`           varchar(40)    NOT NULL
    , `status`             int unsigned
    , PRIMARY KEY  (
                     `user_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;

/* ファイルアップロード関連テーブル */
CREATE TABLE IF NOT EXISTS risoluto_t_upload
(
      `ctime`              datetime       NOT NULL
    , `cuser`              varchar(255)   NOT NULL
    , `mtime`              datetime       NOT NULL
    , `muser`              varchar(255)   NOT NULL
    , `upload_id`          int unsigned   NOT NULL
    , `realname`           varchar(255)   NOT NULL
    , `mime`               varchar(255)   NOT NULL
    , PRIMARY KEY  (
                     `upload_id`
                   )
) ENGINE=InnoDB CHARACTER SET utf8;
