<?php
/**
 * ヘッダ更新内容入力画面クラス
 *
 * ヘッダ更新内容入力画面を実現するためのクラス
 *
 * @package   risoluto
 * @author    Risoluto Developers
 * @license   http://opensource.org/licenses/bsd-license.php new BSD license
 * @copyright (C) 2008-2009 Risoluto Developers / All Rights Reserved.
 */

  /**
   * 基底クラス
   */
  require_once( "admin_site_base.inc" );
  /**
   * データベース操作クラス
   */
  require_once( RISOLUTO_FUNC . 'risoluto_db.php' );

  class headermod_entry extends admin_site_base
  {
    //------------------------------------------------------//
    // クラス変数定義
    //------------------------------------------------------//
    /**
     * データベース操作クラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_db;
    /**
     * ユーティリティクラスインスタンスを保持する変数
     * @access private
     * @var    object
     */
    private $obj_conf;
    /**
     * 取得データを保持する変数
     * @access private
     * @var    object
     */
    private $gotDat;

    //------------------------------------------------------//
    // クラスメソッド定義
    //------------------------------------------------------//
    /**
     * コンストラクタメソッド
     *
     * コンストラクタメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __construct()
    {
    } // end of function:__construct()

    /**
     * クローンメソッド
     *
     * クローンメソッド
     *
     * @param     void なし
     * @return    void なし
     */
    public function __clone()
    {
    } // end of function:__clone()

    /**
     * modelメソッド（モデル）
     *
     * データ取得等のモデルに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function model()
    {
      // 必要なインスタンスを生成
      $this->obj_conf = new RisolutoConf();
      $this->obj_conf->parse( RISOLUTO_CONF . 'risoluto.ini' );

      // スーパバイザセッション又はアドミンセッションが存在しない場合は、
      // ログイン画面に遷移する
      if ( ! $this->obj_util->is_Admin() )
      {
        $this->obj_util->redirectTo( $this->obj_adminconf->get( 'COMMON', 'login_act'  )
                                   , $this->obj_adminconf->get( 'COMMON', 'login_cage' ) );
        return false;
      } // end of if

      // 前画面のCageが「admin.site」でない or 前画面のActが「headerlist」 and 「headermod_confirm」でない場合、
      // 入力画面に飛ばす
      $tmp_cage = str_replace( DIRECTORY_SEPARATOR, '.', $this->obj_sess->sessLoad( 'lastcage' ) );
      $tmp_act  = $this->obj_sess->sessLoad( 'lastact'  );
      if ( $tmp_cage != 'admin.site' or ( $tmp_act != 'headerlist' and $tmp_act != 'headermod_confirm' ) )
      {
        $this->obj_util->redirectTo( 'headerlist', 'admin.user' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // セッション情報の取得
      //------------------------------------------------------------------------
      // 初期化
      $tmp_entered[ 'headerid' ] = null;

      // セッションからエラーメッセージと入力値を取得し、削除する
      $tmp_entered = $this->obj_sess->sessLoad( $this->obj_sess->sessLoad( 'currentcage' ) );
      $this->obj_sess->sessRevoke( $this->obj_sess->sessLoad( 'currentcage' ) );

      // 表示情報をセットする
      $this->gotDat[ 'headerinfo' ] = $tmp_entered;

      // 確認画面からの場合、DBからの取得処理等は行わない
      if ( $tmp_act == 'headermod_confirm' )
      {
        return true;
      } // end of if



      //------------------------------------------------------------------------
      // 前画面の入力値を取得
      //------------------------------------------------------------------------
      // ヘッダID
      if ( isset( $_GET[ 'headerid' ] ) )
      {
        $tmp_entered[ 'headerid' ] = strip_tags( trim( $_GET[ 'headerid' ] ) );
      } // end of if



      //------------------------------------------------------------------------
      // 入力情報のチェック
      //------------------------------------------------------------------------
      // 渡されてきたヘッダIDがnullか数字でなければ、ユーザ選択画面に遷移する
      if ( $tmp_entered[ 'headerid' ] == null or ! is_numeric( $tmp_entered[ 'headerid' ] ) )
      {
        // エラーメッセージ表示用の情報をセッションに入れてから入力画面に遷移する
        $tmp_entered[ 'message' ] = 'invalid_headerid';
        $this->obj_sess->sessStore( $this->obj_sess->sessLoad( 'currentcage' ), $tmp_entered );
        $this->obj_util->redirectTo( 'headerlist', 'admin.site' );
        return false;
      } // end of if



      //------------------------------------------------------------------------
      // ヘッダ情報の取得
      //------------------------------------------------------------------------

      // データベースに接続する
      // データベース操作クラスのインスタンスを生成する
      $this->obj_db = new RisoluteDb();

      // データベースに接続する
      if ( $this->obj_db->dbConnect( $this->obj_conf->get( 'DBS', 'DEFAULT_DSN' ) ) )
      {

        // ユーザ情報を取得する
        // SQL文を組み立てる
        $sql =<<<End_Of_SQL

              SELECT `headers`.`header_id`    -- header ID
                   , `headers`.`act`          -- act
                   , `headers`.`cage`         -- cage
                   , `headers`.`robot_index`  -- robots(index)
                   , `headers`.`robot_follow` -- robots(follow)
                   , `headers`.`title`        -- title
                   , `headers`.`description`  -- description
                   , `headers`.`keywords`     -- keywords
                   , `headers`.`author`       -- author
                   , `headers`.`javascript`   -- javascript
                   , `headers`.`css`          -- css
                   , `headers`.`favicon`      -- favicon
                FROM `risoluto_t_headerinfo` headers
               WHERE `headers`.`header_id` = ?

End_Of_SQL;

        // パラメタも用意する
        $param = array(
                        $tmp_entered[ 'headerid' ]
                      );

        // SQLの実行に失敗した場合は、例外を投げる
        $tmp_headerdat = $this->obj_db->dbGetRow( $sql, $param );
        if ( PEAR::isError( $tmp_headerdat ) )
        {
          // 接続をクローズする
          $this->obj_db->dbDisConnect();
          throw new Exception( 'header information get Failure' );
          return false;
        } // end of if
        // 正常に取得できていれば、クラス変数にセットする
        else
        {
          $this->obj_db->dbDisConnect();
          $this->gotDat[ 'headerinfo' ] = $tmp_headerdat;
        } // end of else

      } // end of if
      // データベースに接続できなかった場合は、例外を投げる
      else
      {
        throw new Exception( 'DB Connection Failure' );
        return false;
      } // end of else



      return true;
    } // end of function:model()

    /**
     * viewメソッド（モデル）
     *
     * テンプレート関連処理等のビューに相当する部分の処理を行う
     *
     * @param     void なし
     * @return    boolean ファンクション実行結果（ true：正常終了 / false: 異常終了 ）
     */
    public function view()
    {
      // アサイン
      $this->smarty->assign ( 'header',    $this->obj_util->getHeader() );

      $this->smarty->assign ( 'menu_cage', $this->obj_adminconf->get( 'COMMON', 'menu_cage' ) );
      $this->smarty->assign ( 'menu_act',  $this->obj_adminconf->get( 'COMMON', 'menu_act'  ) );

      $this->smarty->assign ( 'entered',   $this->gotDat[ 'headerinfo' ] );

      // 表示
      $this->smarty->display( 'headermod_entry.tpl' );

      return true;

    } // end of function:view()

  } // end of class:headermod_entry

?>
