import sys
import re

from VersionInfo import *


def ConvertVersion_A(line, head):
	reg = "^((\t| )*)" + head + "(.*,)(.*,)(.*,)(.*)"
	m = re.search(reg, line)
	if m == None:
		return line

	dst = m.group(1) + head + getFullVersionC() + "\n"
	return dst

def ConvertVersion_B(line, head):
	reg = "^((\t| )*)" + head + "\"(.*\.)(.*\.)(.*\.)(.*)\""
	m = re.search(reg, line)
	if m == None:
		return line

	dst = m.group(1) + head + "\"" + getFullVersion() + "\"" + "\n"
	return dst

def SetVersion(filename):
	lines = []
	for line in open(filename):
		line = ConvertVersion_A(line, "FILEVERSION "               )
		line = ConvertVersion_A(line, "PRODUCTVERSION "            )
		line = ConvertVersion_B(line, "VALUE \"FileVersion\", "    )
		line = ConvertVersion_B(line, "VALUE \"ProductVersion\", " )
		lines.append(line)

	f = open(filename, "w")
	for line in lines:
		f.write(line)
	f.close()

def main():
	argv = sys.argv
	argc = len(argv)
	if argc != 2:
		print("Usage: " + argv[0] + " resourcefile")
		return

	SetVersion(argv[1])

main()
