#include "stdafx.h"
#include "PostprocLibrary.h"

#include "Postproc/NullPostproc.h"
#include "Postproc/Antialias.h"
#include "Postproc/Border.h"
#include "Postproc/DepthLayerColor.h"
#include "Postproc/DepthColor.h"
#include "Postproc/DepthOfField.h"



PostprocInterface* PosprocLibrary::GetOrCreatePostproc(PostProcType type)
{
	switch(type)
	{
	case PostProcType::Antialias       : return GetAntialias();
	case PostProcType::Border          : return GetBorder();
	case PostProcType::DepthLayerColor : return GetDepthLayerColor();
	case PostProcType::DepthColor      : return GetDepthColor();
	case PostProcType::DepthOfField    : return GetDepthOfField();

	default:
		assert(false);
		return NULL;
	}
}


AntialiasPostproc* PosprocLibrary::GetAntialias(void)
{
	if (m_Antialias.get() != NULL)
		return m_Antialias.get();

	AntialiasPostproc* pp = new AntialiasPostproc(m_Context);
	m_Antialias.reset(pp);

	return pp;
}

BorderPostproc* PosprocLibrary::GetBorder(void)
{
	if (m_Border.get() != NULL)
		return m_Border.get();

	BorderPostproc* pp = new BorderPostproc(m_Context);
	m_Border.reset(pp);

	return pp;
}

DepthLayerColorPostproc* PosprocLibrary::GetDepthLayerColor(void)
{
	if (m_DepthColor.get() != NULL)
		return m_DepthLayerColor.get();

	DepthLayerColorPostproc* pp = new DepthLayerColorPostproc(m_Context);
	m_DepthLayerColor.reset(pp);

	return pp;
}

DepthColorPostproc* PosprocLibrary::GetDepthColor(void)
{
	if (m_DepthColor.get() != NULL)
		return m_DepthColor.get();

	DepthColorPostproc* pp = new DepthColorPostproc(m_Context);
	m_DepthColor.reset(pp);

	return pp;
}

DepthOfFieldPostproc* PosprocLibrary::GetDepthOfField(void)
{
	if (m_DepthOfField.get() != NULL)
		return m_DepthOfField.get();

	DepthOfFieldPostproc* pp = new DepthOfFieldPostproc(m_Context);
	m_DepthOfField.reset(pp);

	return pp;
}
