#include "stdafx.h"
#include "Antialias.h"

#include "../PathInfo.h"
#include "../ShaderUtil.h"



AntialiasPostproc::AntialiasPostproc(PostprocContext* context) : 
	PostprocInterface(context)
{
	QString shader_path = PathInfo::GetPostprocCodeDirPath();

	std::string p = shader_path.toLocal8Bit().data();

	std::string frag_filename = p + "Antialias.frag";
	std::string vert_filename = p + "Antialias.vert";

	ShaderUtil::InitShaderStd(m_Shader, frag_filename, vert_filename);
}

void AntialiasPostproc::BeginRender(void)
{
	m_Shader.BeginShader();

	SetStandardSiinglePathPPTextureConfig(m_Shader);
}

void AntialiasPostproc::EndRender(void)
{
	m_Shader.EndShader();
}
