#pragma once

#include <LibQtGeoViewerCore/Transform.h>

#include "NamedValue.h"



class View3DConfig;
class SceneMain;


class GuiConfig
{
public:
	GuiConfig(void)
	{
		m_EnableAllFeatures .Reset(false, "EnableAllFeatures");
		m_TextureFlipY      .Reset(true, "FlipY");
		m_AutFitUVView      .Reset(false, "AutFitUVView");

		m_CoordType .Reset(0, "CoordType");
		m_RevZ      .Reset(false, "RevZ");
	}

	bool SaveConfigT(const char* filename);
	bool LoadConfigT(const char* filename);

public:
	View3DConfig* m_Config3D;
	SceneMain*    m_Scene;

	NamedValue<bool> m_EnableAllFeatures;

	NamedValue<bool> m_TextureFlipY;
	NamedValue<bool> m_AutFitUVView;

	NamedValue<int>  m_CoordType;
	NamedValue<bool> m_RevZ;

	std::vector<QString> m_RecentFiles;
};



class WindowConfig
{
public:
	WindowConfig(void)
	{
		m_MainWinLeft   = 0;
		m_MainWinTop    = 0;
		m_MainWinWidth  = 100;
		m_MainWinHeight = 100;
		m_IsMaximized   = false;
	}

	bool SaveConfig(const char* filename);
	bool LoadConfig(const char* filename);

public:
	int m_MainWinLeft;
	int m_MainWinTop;
	int m_MainWinWidth;
	int m_MainWinHeight;
	bool m_IsMaximized;
};
