#include "StdAfx.h"
#include "Cursor3D.h"

#include <LibQtGeoViewerCore/GeomObject.h>



Cursor3D::Cursor3D(void)
{
	ShowCursor     .Reset( false , "ShowCursor"     );
	CursorDepth    .Reset( false , "CursorDepth"    );
	ShowMeasure    .Reset( false , "ShowMeasure"    );
	ShowMeasureLen .Reset( false , "ShowMeasureLen" );
	ShowMeasureXYZ .Reset( false , "ShowMeasureXYZ" );
	ShowAxis       .Reset( false , "ShowAxis"       );
	ShowCoord      .Reset( false , "ShowCoord"      );
	CheckBaryCoord .Reset( false , "CheckBaryCoord" );

	MakeHole = false;
	HoleRangeRatio = 0.25f;

	CloseFaceObject = NULL;
}

void Cursor3D::ResetCursorPos(void)
{
	CursorPos.set(0.0f, 0.0f, 0.0f);
}

void Cursor3D::ResetMeasure(void)
{
	MeasurePos = CursorPos;
}

void Cursor3D::ResetCloseFace(void)
{
	CloseFaceObject = NULL;
	CloseFace.Reset();
}

lm::vec3f Cursor3D::GetMidMeasurePos(void) const
{
	return (CursorPos + MeasurePos) * 0.5f;
}

float Cursor3D::GetMeasureLength(void) const
{
	return (CursorPos - MeasurePos).length();
}


void Cursor3D::UpdateNormal(const lm::vec3f& ep)
{
	const lm::vec3f& e0 = CursorPos;
	const lm::vec3f& e1 = MeasurePos;
	if(CursorPos == MeasurePos)
		MeasureNorm.set_zero();
	else
		MeasureNorm = lm::cross(e1 - e0, ep).get_normalize();
}

bool Cursor3D::IsHoleActive(void) const
{
	return MakeHole && ShowCursor;
}
