from IOUtil import *

Qt5Dir = 'C:/Qt/Qt5.1.0/5.1.0/msvc2012_32_opengl-bld/'


def copyAssimpLibs(OutDir):
	AssimpDir = 'C:/Program Files/Assimp/bin/x86/'
	copyFiles(AssimpDir + 'Assimp32.dll', OutDir)
	copyFiles(AssimpDir + 'D3DCompiler_42.dll', OutDir)
	copyFiles(AssimpDir + 'D3DX9_42.dll', OutDir)

def copyGLLibs(OutDir):
	LibRoot = '../../LibExt/'
	copyFiles(LibRoot + 'glew-1.5.5/bin/glew32.dll', OutDir)
	copyFiles(LibRoot + 'OpenGLUT/OpenGLUT.dll', OutDir)

def copySDLLibs(OutDir):
	SDLRoot = '../../LibExt/SDL-1.2.14/lib/'
	copyFiles(SDLRoot + 'SDL.dll', OutDir)

	SDLImgRoot = '../../LibExt/SDL_image-1.2.10/lib/'
	copyFiles(SDLImgRoot + 'jpeg.dll', OutDir)
	copyFiles(SDLImgRoot + 'libpng12-0.dll', OutDir)
	copyFiles(SDLImgRoot + 'libtiff-3.dll', OutDir)
	copyFiles(SDLImgRoot + 'SDL_image.dll', OutDir)
	copyFiles(SDLImgRoot + 'zlib1.dll', OutDir)

def copyPythonLibs(OutDir):
	copyFiles('C:/Python26/Python26.dll', OutDir)

def copyQtLib(Release, SrcDir, OutDir, name):
	srcfile = SrcDir + name
	if not Release:
		srcfile += 'd'
	srcfile += ".dll"
	copyFiles(srcfile, OutDir)

def copyTranslation(SrcDir, OutDir, language):
	srcfile = SrcDir + 'qt_' + language + '.qm'
	copyFiles(srcfile, OutDir)

def copyQtLibsMain(OutDir, release):
	createPathIfnotExist(OutDir)
	createPathIfnotExist(OutDir + 'platforms/')
	createPathIfnotExist(OutDir + 'imageformats/')
	createPathIfnotExist(OutDir + 'translations/')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5Core')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5Gui')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5OpenGl')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5PrintSupport')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5Widgets')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5Xml')
	copyQtLib(release, Qt5Dir + 'bin/', OutDir, 'Qt5Network')
	copyQtLib(release, Qt5Dir + 'plugins/platforms/', OutDir + 'platforms/', 'qwindows')
	copyQtLib(release, Qt5Dir + 'plugins/imageformats/', OutDir + 'imageformats/', 'qjpeg')
	copyTranslation(Qt5Dir + 'translations/', OutDir + 'translations/', 'ja')

def copyQtLibs(OutDir):
	copyQtLibsMain(OutDir, True)

def copyQtLibsD(OutDir):
	copyQtLibsMain(OutDir, False)
