#pragma once

#include <vector>

#include "NamedElement.h"



namespace lib_geo
{


class ColladaNode;
class ColladaMesh;


class BoneBind
{
public:
	int   m_JointIdx;
	float m_Weight;
};


class BoneBindNode : public NamedElement
{
public:
	BoneBindNode(void)
		: m_Node(NULL)
	{}

public:
	ColladaNode* m_Node;
};


class VertBondBinds
{
public:
	std::vector<BoneBind> m_Binds;
};


class ColladaBone : public NamedElement
{
public:
	ColladaMesh*                m_SrcMesh;

	lm::matrix4f                m_BindShapeMat;

	std::vector<BoneBindNode>   m_Nodes;
	std::vector<VertBondBinds>  m_Binds;
};


}
